/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend;

import java.io.IOException;
import java.util.List;
import org.drools.compiler.compiler.DroolsParserException;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.io.ResourceFactory;

public abstract class RuleUnit {
    public KieSession getKieSession(String uri) throws DroolsParserException, IOException, Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write(ResourceFactory.newClassPathResource((String)uri, this.getClass())).writeKModuleXML(this.createKieProjectWithPackages(ks).toXML());
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        List results = builder.getResults().getMessages();
        Assert.assertTrue((String)results.toString(), (boolean)results.isEmpty());
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        return ksession;
    }

    private KieModuleModel createKieProjectWithPackages(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setEventProcessingMode(EventProcessingOption.STREAM).addPackage("*").setDefault(true);
        kieBaseModel1.newKieSessionModel("KSession1").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.PSEUDO).setDefault(true);
        return kproj;
    }
}

