/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.testscenarios.backend;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.RetractFact;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.models.testscenarios.shared.VerifyFact;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.drools.workbench.models.testscenarios.shared.VerifyRuleFired;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioTest {
    @Test
    public void testInsertBetween() {
        Scenario sc = new Scenario();
        VerifyRuleFired vf = new VerifyRuleFired();
        sc.insertBetween(null, (Fixture)vf);
        Assert.assertEquals((long)1L, (long)sc.getFixtures().size());
        Assert.assertEquals((Object)vf, sc.getFixtures().get(0));
        VerifyRuleFired vf2 = new VerifyRuleFired();
        sc.getFixtures().add(vf2);
        VerifyRuleFired vf3 = new VerifyRuleFired();
        sc.insertBetween((Fixture)vf, (Fixture)vf3);
        Assert.assertEquals((long)3L, (long)sc.getFixtures().size());
        Assert.assertEquals((Object)vf, sc.getFixtures().get(0));
        Assert.assertEquals((Object)vf2, sc.getFixtures().get(1));
        Assert.assertEquals((Object)vf3, sc.getFixtures().get(2));
        VerifyRuleFired vf4 = new VerifyRuleFired();
        sc.insertBetween((Fixture)vf2, (Fixture)vf4);
        Assert.assertEquals((long)4L, (long)sc.getFixtures().size());
        Assert.assertEquals((long)3L, (long)sc.getFixtures().indexOf(vf4));
        Assert.assertEquals((long)2L, (long)sc.getFixtures().indexOf(vf3));
        Assert.assertEquals((long)1L, (long)sc.getFixtures().indexOf(vf2));
        Assert.assertEquals((long)0L, (long)sc.getFixtures().indexOf(vf));
        VerifyRuleFired vf5 = new VerifyRuleFired();
        sc.insertBetween(null, (Fixture)vf5);
        Assert.assertEquals((long)5L, (long)sc.getFixtures().size());
        Assert.assertEquals((long)4L, (long)sc.getFixtures().indexOf(vf5));
        sc = new Scenario();
        sc.getFixtures().add(vf);
        ExecutionTrace ex = new ExecutionTrace();
        sc.getFixtures().add(ex);
        sc.insertBetween(null, (Fixture)vf2);
        Assert.assertEquals((long)0L, (long)sc.getFixtures().indexOf(vf));
        Assert.assertEquals((long)1L, (long)sc.getFixtures().indexOf(vf2));
        Assert.assertEquals((long)2L, (long)sc.getFixtures().indexOf(ex));
        Assert.assertEquals((long)3L, (long)sc.getFixtures().size());
        sc.insertBetween((Fixture)ex, (Fixture)vf3);
        Assert.assertEquals((long)4L, (long)sc.getFixtures().size());
        Assert.assertEquals((long)0L, (long)sc.getFixtures().indexOf(vf));
        Assert.assertEquals((long)1L, (long)sc.getFixtures().indexOf(vf2));
        Assert.assertEquals((long)2L, (long)sc.getFixtures().indexOf(ex));
        Assert.assertEquals((long)3L, (long)sc.getFixtures().indexOf(vf3));
        ExecutionTrace ex2 = new ExecutionTrace();
        sc.getFixtures().add(ex2);
        sc.insertBetween((Fixture)ex, (Fixture)vf4);
        Assert.assertEquals((long)6L, (long)sc.getFixtures().size());
        Assert.assertEquals((long)0L, (long)sc.getFixtures().indexOf(vf));
        Assert.assertEquals((long)1L, (long)sc.getFixtures().indexOf(vf2));
        Assert.assertEquals((long)2L, (long)sc.getFixtures().indexOf(ex));
        Assert.assertEquals((long)3L, (long)sc.getFixtures().indexOf(vf3));
        Assert.assertEquals((long)4L, (long)sc.getFixtures().indexOf(vf4));
        Assert.assertEquals((long)5L, (long)sc.getFixtures().indexOf(ex2));
        sc.insertBetween((Fixture)ex2, (Fixture)vf5);
        Assert.assertEquals((long)7L, (long)sc.getFixtures().size());
        Assert.assertEquals((long)0L, (long)sc.getFixtures().indexOf(vf));
        Assert.assertEquals((long)1L, (long)sc.getFixtures().indexOf(vf2));
        Assert.assertEquals((long)2L, (long)sc.getFixtures().indexOf(ex));
        Assert.assertEquals((long)3L, (long)sc.getFixtures().indexOf(vf3));
        Assert.assertEquals((long)4L, (long)sc.getFixtures().indexOf(vf4));
        Assert.assertEquals((long)5L, (long)sc.getFixtures().indexOf(ex2));
        Assert.assertEquals((long)6L, (long)sc.getFixtures().indexOf(vf5));
        sc = new Scenario();
        sc.getFixtures().add(ex);
        sc.insertBetween(null, (Fixture)vf);
        Assert.assertEquals((long)2L, (long)sc.getFixtures().size());
        Assert.assertEquals((long)0L, (long)sc.getFixtures().indexOf(vf));
        Assert.assertEquals((long)1L, (long)sc.getFixtures().indexOf(ex));
    }

    @Test
    public void testExecutionTrace() {
        Scenario sc = new Scenario();
        sc.getGlobals().add(new FactData("A", "A", new ArrayList(), false));
        sc.getFixtures().add(new FactData("B", "B", new ArrayList(), true));
        sc.getFixtures().add(new FactData("C", "C", new ArrayList(), true));
        ExecutionTrace ex1 = new ExecutionTrace();
        sc.getFixtures().add(ex1);
        sc.getFixtures().add(new VerifyFact());
        sc.getFixtures().add(new RetractFact());
        sc.getFixtures().add(new FactData("D", "D", new ArrayList(), false));
        sc.getFixtures().add(new FactData("E", "E", new ArrayList(), false));
        ExecutionTrace ex2 = new ExecutionTrace();
        sc.getFixtures().add(ex2);
        sc.getFixtures().add(new VerifyFact());
        sc.getFixtures().add(new FactData("F", "F", new ArrayList(), false));
        ExecutionTrace ex3 = new ExecutionTrace();
        sc.getFixtures().add(ex3);
        Assert.assertEquals((long)11L, (long)sc.getFixtures().size());
        sc.removeExecutionTrace(ex2);
        Assert.assertEquals((long)6L, (long)sc.getFixtures().size());
        Assert.assertTrue((boolean)sc.isFactNameReserved("A"));
        Assert.assertTrue((boolean)sc.isFactNameReserved("B"));
        Assert.assertTrue((boolean)sc.isFactNameReserved("C"));
        Assert.assertFalse((boolean)sc.isFactNameReserved("D"));
        Assert.assertFalse((boolean)sc.isFactNameReserved("E"));
        Assert.assertTrue((boolean)sc.isFactNameReserved("F"));
    }

    @Test
    public void testRemoveFixture() {
        Scenario sc = new Scenario();
        VerifyRuleFired vf1 = new VerifyRuleFired();
        VerifyRuleFired vf2 = new VerifyRuleFired();
        VerifyRuleFired vf3 = new VerifyRuleFired();
        FactData fd = new FactData();
        sc.getFixtures().add(vf1);
        sc.getFixtures().add(vf2);
        sc.getFixtures().add(vf3);
        sc.getGlobals().add(fd);
        sc.removeFixture((Fixture)vf2);
        Assert.assertEquals((long)2L, (long)sc.getFixtures().size());
        Assert.assertEquals((Object)vf1, sc.getFixtures().get(0));
        Assert.assertEquals((Object)vf3, sc.getFixtures().get(1));
        Assert.assertEquals((long)1L, (long)sc.getGlobals().size());
        sc.removeFixture((Fixture)fd);
        Assert.assertEquals((long)0L, (long)sc.getGlobals().size());
        Assert.assertEquals((long)2L, (long)sc.getFixtures().size());
    }

    @Test
    public void testMapFactTypes() {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData("X", "q", null, false));
        sc.getGlobals().add(new FactData("Q", "x", null, false));
        Map r = sc.getVariableTypes();
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertEquals((Object)"X", r.get("q"));
        Assert.assertEquals((Object)"Q", r.get("x"));
    }

    @Test
    public void testVariablesInScope() {
        Scenario sc = new Scenario();
        sc.getGlobals().add(new FactData("X", "x", new ArrayList(), false));
        sc.getFixtures().add(new FactData("Q", "q", new ArrayList(), true));
        sc.getFixtures().add(new FactData("Z", "z", new ArrayList(), false));
        ExecutionTrace ex1 = new ExecutionTrace();
        sc.getFixtures().add(ex1);
        sc.getFixtures().add(new RetractFact("z"));
        sc.getFixtures().add(new FactData("Y", "y", new ArrayList(), false));
        ExecutionTrace ex2 = new ExecutionTrace();
        sc.getFixtures().add(ex2);
        List l = sc.getFactNamesInScope(ex1, true);
        Assert.assertEquals((long)3L, (long)l.size());
        Assert.assertEquals((Object)"q", l.get(0));
        Assert.assertEquals((Object)"z", l.get(1));
        Assert.assertEquals((Object)"x", l.get(2));
        l = sc.getFactNamesInScope(ex1, false);
        Assert.assertEquals((long)2L, (long)l.size());
        Assert.assertFalse((boolean)l.contains(sc.getGlobals().get(0)));
        l = sc.getFactNamesInScope(ex2, true);
        Assert.assertEquals((long)3L, (long)l.size());
        Assert.assertEquals((Object)"q", l.get(0));
        Assert.assertEquals((Object)"y", l.get(1));
        Assert.assertEquals((Object)"x", l.get(2));
        l = sc.getFactNamesInScope(null, true);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testAllowRemoveFact() {
        Scenario sc = new Scenario();
        FactData fd1 = new FactData("X", "x", new ArrayList(), false);
        sc.getFixtures().add(fd1);
        FactData fd2 = new FactData("Q", "q", new ArrayList(), false);
        sc.getFixtures().add(fd2);
        FactData fd3 = new FactData("Z", "z", new ArrayList(), false);
        sc.getFixtures().add(fd3);
        ExecutionTrace ex1 = new ExecutionTrace();
        FactData fd4 = new FactData("I", "i", new ArrayList(), false);
        sc.getGlobals().add(fd4);
        sc.getFixtures().add(ex1);
        sc.getFixtures().add(new RetractFact("z"));
        sc.getFixtures().add(new FactData("Z", "z", new ArrayList(), true));
        sc.getFixtures().add(new VerifyFact("q", new ArrayList()));
        Assert.assertFalse((boolean)sc.isFactDataReferenced(fd1));
        Assert.assertTrue((boolean)sc.isFactDataReferenced(fd2));
        Assert.assertTrue((boolean)sc.isFactDataReferenced(fd3));
        Assert.assertFalse((boolean)sc.isFactDataReferenced(fd4));
    }

    @Test
    public void testIsFactNameUsed() {
        Scenario sc = new Scenario();
        sc.getGlobals().add(new FactData("X", "x", null, false));
        sc.getFixtures().add(new FactData("Q", "q", null, false));
        sc.getFixtures().add(new ExecutionTrace());
        Assert.assertTrue((boolean)sc.isFactNameReserved("x"));
        Assert.assertTrue((boolean)sc.isFactNameReserved("q"));
        Assert.assertFalse((boolean)sc.isFactNameReserved("w"));
        sc = new Scenario();
        Assert.assertFalse((boolean)sc.isFactNameReserved("w"));
    }

    @Test
    public void testCountSuccessFailures() {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData());
        sc.getFixtures().add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired();
        vr.setSuccessResult(Boolean.valueOf(false));
        sc.getFixtures().add(vr);
        VerifyField vf = new VerifyField();
        vf.setSuccessResult(Boolean.valueOf(true));
        VerifyField vf2 = new VerifyField();
        vf2.setSuccessResult(Boolean.valueOf(false));
        VerifyFact vfact = new VerifyFact();
        vfact.getFieldValues().add(vf);
        vfact.getFieldValues().add(vf2);
        sc.getFixtures().add(vfact);
        int[] totals = sc.countFailuresTotal();
        Assert.assertEquals((long)2L, (long)totals[0]);
        Assert.assertEquals((long)3L, (long)totals[1]);
    }
}

