/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.Reoccurring;
import org.kie.api.executor.STATUS;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.RequestInfoLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogDeleteBuilder;
import org.kie.internal.task.query.AuditTaskDeleteBuilder;
import org.kie.internal.task.query.TaskEventDeleteBuilder;
import org.kie.internal.task.query.TaskVariableDeleteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCleanupCommand
implements Command,
Reoccurring {
    private static final Logger logger = LoggerFactory.getLogger(LogCleanupCommand.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private long nextScheduleTimeAdd = 86400000L;

    public Date getScheduleTime() {
        if (this.nextScheduleTimeAdd < 0L) {
            return null;
        }
        long current = System.currentTimeMillis();
        Date nextSchedule = new Date(current + this.nextScheduleTimeAdd);
        logger.debug("Next schedule for job {} is set to {}", (Object)this.getClass().getSimpleName(), (Object)nextSchedule);
        return nextSchedule;
    }

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        String nextRun;
        String singleRun;
        boolean skipProcessLog = ctx.getData().containsKey("SkipProcessLog") ? Boolean.parseBoolean((String)ctx.getData("SkipProcessLog")) : false;
        boolean skipTaskLog = ctx.getData().containsKey("SkipTaskLog") ? Boolean.parseBoolean((String)ctx.getData("SkipTaskLog")) : false;
        boolean skipExecutorLog = ctx.getData().containsKey("SkipExecutorLog") ? Boolean.parseBoolean((String)ctx.getData("SkipExecutorLog")) : false;
        SimpleDateFormat formatToUse = DATE_FORMAT;
        String dataFormat = (String)ctx.getData("DateFormat");
        if (dataFormat != null) {
            formatToUse = new SimpleDateFormat(dataFormat);
        }
        ExecutionResults executionResults = new ExecutionResults();
        String emfName = (String)ctx.getData("EmfName");
        if (emfName == null) {
            emfName = "org.jbpm.domain";
        }
        if ("true".equalsIgnoreCase(singleRun = (String)ctx.getData("SingleRun"))) {
            this.nextScheduleTimeAdd = -1L;
        }
        if ((nextRun = (String)ctx.getData("NextRun")) != null) {
            this.nextScheduleTimeAdd = DateTimeUtils.parseDateAsDuration((String)nextRun);
        }
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(emfName);
        ExecutorJPAAuditService auditLogService = new ExecutorJPAAuditService(emf);
        String olderThan = (String)ctx.getData("OlderThan");
        String olderThanPeriod = (String)ctx.getData("OlderThanPeriod");
        String forProcess = (String)ctx.getData("ForProcess");
        String forDeployment = (String)ctx.getData("ForDeployment");
        if (olderThanPeriod != null) {
            long olderThanDuration = DateTimeUtils.parseDateAsDuration((String)olderThanPeriod);
            Date olderThanDate = new Date(System.currentTimeMillis() - olderThanDuration);
            olderThan = formatToUse.format(olderThanDate);
        }
        if (!skipTaskLog) {
            long taLogsRemoved = 0L;
            taLogsRemoved = ((AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)auditLogService.auditTaskDelete().processId(new String[]{forProcess})).dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).deploymentId(new String[]{forDeployment}).build().execute();
            logger.info("TaskAuditLogRemoved {}", (Object)taLogsRemoved);
            executionResults.setData("TaskAuditLogRemoved", (Object)taLogsRemoved);
            long teLogsRemoved = 0L;
            teLogsRemoved = ((TaskEventDeleteBuilder)auditLogService.taskEventInstanceLogDelete().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).build().execute();
            logger.info("TaskEventLogRemoved {}", (Object)teLogsRemoved);
            executionResults.setData("TaskEventLogRemoved", (Object)teLogsRemoved);
            long tvLogsRemoved = 0L;
            tvLogsRemoved = ((TaskVariableDeleteBuilder)auditLogService.taskVariableInstanceLogDelete().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).build().execute();
            logger.info("TaskVariableLogRemoved {}", (Object)tvLogsRemoved);
            executionResults.setData("TaskVariableLogRemoved", (Object)tvLogsRemoved);
        }
        if (!skipProcessLog) {
            long niLogsRemoved = 0L;
            niLogsRemoved = ((NodeInstanceLogDeleteBuilder)((NodeInstanceLogDeleteBuilder)auditLogService.nodeInstanceLogDelete().processId(new String[]{forProcess})).dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).externalId(new String[]{forDeployment}).build().execute();
            logger.info("NodeInstanceLogRemoved {}", (Object)niLogsRemoved);
            executionResults.setData("NodeInstanceLogRemoved", (Object)niLogsRemoved);
            long viLogsRemoved = 0L;
            viLogsRemoved = ((VariableInstanceLogDeleteBuilder)((VariableInstanceLogDeleteBuilder)auditLogService.variableInstanceLogDelete().processId(new String[]{forProcess})).dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).externalId(new String[]{forDeployment}).build().execute();
            logger.info("VariableInstanceLogRemoved {}", (Object)viLogsRemoved);
            executionResults.setData("VariableInstanceLogRemoved", (Object)viLogsRemoved);
            long piLogsRemoved = 0L;
            piLogsRemoved = ((ProcessInstanceLogDeleteBuilder)auditLogService.processInstanceLogDelete().processId(new String[]{forProcess})).status(new int[]{2, 3}).endDateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan)).externalId(new String[]{forDeployment}).build().execute();
            logger.info("ProcessInstanceLogRemoved {}", (Object)piLogsRemoved);
            executionResults.setData("ProcessInstanceLogRemoved", (Object)piLogsRemoved);
        }
        if (!skipExecutorLog) {
            long errorInfoLogsRemoved = 0L;
            errorInfoLogsRemoved = ((ErrorInfoDeleteBuilder)auditLogService.errorInfoLogDeleteBuilder().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).build().execute();
            logger.info("ErrorInfoLogsRemoved {}", (Object)errorInfoLogsRemoved);
            executionResults.setData("ErrorInfoLogsRemoved", (Object)errorInfoLogsRemoved);
            long requestInfoLogsRemoved = 0L;
            requestInfoLogsRemoved = ((RequestInfoLogDeleteBuilder)auditLogService.requestInfoLogDeleteBuilder().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).status(new STATUS[]{STATUS.CANCELLED, STATUS.DONE, STATUS.ERROR}).build().execute();
            logger.info("RequestInfoLogsRemoved {}", (Object)requestInfoLogsRemoved);
            executionResults.setData("RequestInfoLogsRemoved", (Object)requestInfoLogsRemoved);
        }
        long bamLogsRemoved = 0L;
        executionResults.setData("BAMLogRemoved", (Object)bamLogsRemoved);
        return executionResults;
    }
}

