/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.commands.FindObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;

public class ExecutorQueryServiceImpl
implements ExecutorQueryService {
    private CommandExecutor commandService;
    private List<STATUS> waitingForExecutionOnly = Arrays.asList(STATUS.QUEUED, STATUS.RETRYING);

    public ExecutorQueryServiceImpl(boolean active) {
        QueryManager.get().addNamedQueries("META-INF/Executor-orm.xml");
    }

    public void setCommandService(CommandExecutor commandService) {
        this.commandService = commandService;
    }

    public List<org.kie.api.executor.RequestInfo> getPendingRequests() {
        return this.getPendingRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getPendingRequestById(Long id) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", id);
        return (List)this.commandService.execute((Command)new QueryNameCommand("PendingRequestById", params));
    }

    public org.kie.api.executor.RequestInfo getRequestById(Long id) {
        return (org.kie.api.executor.RequestInfo)this.commandService.execute((Command)new FindObjectCommand((Object)id, RequestInfo.class));
    }

    public List<org.kie.api.executor.RequestInfo> getRunningRequests() {
        return this.getRunningRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getQueuedRequests() {
        return this.getQueuedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getFutureQueuedRequests() {
        return this.getFutureQueuedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getCompletedRequests() {
        return this.getCompletedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getInErrorRequests() {
        return this.getInErrorRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getCancelledRequests() {
        return this.getCancelledRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<ErrorInfo> getAllErrors() {
        return this.getAllErrors(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", requestId);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetErrorsByRequestId", params));
    }

    public List<org.kie.api.executor.RequestInfo> getAllRequests() {
        return this.getAllRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        return this.getRequestsByStatus(statuses, new QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
    }

    public List<org.kie.api.executor.RequestInfo> getRequestByBusinessKey(String businessKey, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessKey", businessKey);
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByBusinessKey", params));
    }

    public List<org.kie.api.executor.RequestInfo> getRequestByCommand(String command, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", command);
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByCommand", params));
    }

    public org.kie.api.executor.RequestInfo getRequestForProcessing() {
        org.kie.api.executor.RequestInfo request = (org.kie.api.executor.RequestInfo)this.commandService.execute((Command)new LockAndUpdateRequestInfoCommand());
        return request;
    }

    public org.kie.api.executor.RequestInfo getRequestForProcessing(Long requestId) {
        org.kie.api.executor.RequestInfo request = (org.kie.api.executor.RequestInfo)this.commandService.execute((Command)new LockAndUpdateRequestInfoByIdCommand(requestId));
        return request;
    }

    public List<org.kie.api.executor.RequestInfo> getQueuedRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("QueuedRequests", params));
    }

    public List<org.kie.api.executor.RequestInfo> getCompletedRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("CompletedRequests", params));
    }

    public List<org.kie.api.executor.RequestInfo> getInErrorRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("InErrorRequests", params));
    }

    public List<org.kie.api.executor.RequestInfo> getCancelledRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("CancelledRequests", params));
    }

    public List<ErrorInfo> getAllErrors(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetAllErrors", params));
    }

    public List<org.kie.api.executor.RequestInfo> getAllRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetAllRequests", params));
    }

    public List<org.kie.api.executor.RequestInfo> getRunningRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("RunningRequests", params));
    }

    public List<org.kie.api.executor.RequestInfo> getFutureQueuedRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        params.put("now", new Date());
        return (List)this.commandService.execute((Command)new QueryNameCommand("FutureQueuedRequests", params));
    }

    public List<org.kie.api.executor.RequestInfo> getRequestsByStatus(List<STATUS> statuses, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        params.put("statuses", statuses);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByStatus", params));
    }

    public List<org.kie.api.executor.RequestInfo> getPendingRequests(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        params.put("now", new Date());
        return (List)this.commandService.execute((Command)new QueryNameCommand("PendingRequests", params));
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    public List<org.kie.api.executor.RequestInfo> getRequestsByBusinessKey(String businessKey, List<STATUS> statuses, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessKey", businessKey);
        params.put("statuses", this.adjust(statuses));
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByBusinessKeyAndStatus", params));
    }

    public List<org.kie.api.executor.RequestInfo> getRequestsByCommand(String command, List<STATUS> statuses, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", command);
        params.put("statuses", this.adjust(statuses));
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByCommandAndStatus", params));
    }

    public List<org.kie.api.executor.RequestInfo> getRequestsByDeployment(String deploymentId, List<STATUS> statuses, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("statuses", this.adjust(statuses));
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByDeploymentAndStatus", params));
    }

    public List<org.kie.api.executor.RequestInfo> getRequestsByProcessInstance(Long processInstanceId, List<STATUS> statuses, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("statuses", this.adjust(statuses));
        this.applyQueryContext(params, queryContext);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByProcessInstanceAndStatus", params));
    }

    protected List<STATUS> adjust(List<STATUS> statuses) {
        if (statuses == null || statuses.isEmpty()) {
            return this.waitingForExecutionOnly;
        }
        return statuses;
    }

    protected List<String> getDeploymentIds() {
        ArrayList<String> deployed = new ArrayList<String>(RuntimeManagerRegistry.get().getRegisteredIdentifiers());
        if (deployed.isEmpty()) {
            deployed.add("");
        }
        return deployed;
    }

    private class LockAndUpdateRequestInfoByIdCommand
    implements ExecutableCommand<org.kie.api.executor.RequestInfo> {
        private static final long serialVersionUID = 8670412133363766161L;
        private Long requestId;

        LockAndUpdateRequestInfoByIdCommand(Long requestId) {
            this.requestId = requestId;
        }

        public org.kie.api.executor.RequestInfo execute(Context context) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("requestId", this.requestId);
            params.put("deploymentId", ExecutorQueryServiceImpl.this.getDeploymentIds());
            org.kie.api.executor.RequestInfo request = null;
            JpaPersistenceContext ctx = (JpaPersistenceContext)context;
            List foundInstance = (List)ctx.queryAndLockWithParametersInTransaction("PendingRequestByIdForProcessing", params, false, List.class);
            if (foundInstance != null && !foundInstance.isEmpty() && (request = (org.kie.api.executor.RequestInfo)foundInstance.get(0)) != null) {
                request.setStatus(STATUS.RUNNING);
                ((RequestInfo)request).setTime(new Date());
                ctx.merge((Object)request);
            }
            return request;
        }
    }

    private class LockAndUpdateRequestInfoCommand
    implements ExecutableCommand<org.kie.api.executor.RequestInfo> {
        private static final long serialVersionUID = 8670412133363766161L;

        private LockAndUpdateRequestInfoCommand() {
        }

        public org.kie.api.executor.RequestInfo execute(Context context) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("now", new Date());
            params.put("firstResult", 0);
            params.put("maxResults", 1);
            params.put("owner", ExecutorService.EXECUTOR_ID);
            params.put("deploymentId", ExecutorQueryServiceImpl.this.getDeploymentIds());
            org.kie.api.executor.RequestInfo request = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                request = (org.kie.api.executor.RequestInfo)ctx.queryAndLockWithParametersInTransaction("PendingRequestsForProcessing", params, true, org.kie.api.executor.RequestInfo.class);
                if (request != null) {
                    request.setStatus(STATUS.RUNNING);
                    ((RequestInfo)request).setTime(new Date());
                    ctx.merge((Object)request);
                }
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            return request;
        }
    }
}

