/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;

public class PackageBinding
extends Binding
implements TypeConstants {
    public long tagBits = 0L;
    public char[][] compoundName;
    PackageBinding parent;
    public LookupEnvironment environment;
    HashtableOfType knownTypes;
    HashtableOfPackage knownPackages;
    protected int defaultNullness = 0;

    protected PackageBinding() {
    }

    public PackageBinding(char[] topLevelPackageName, LookupEnvironment environment) {
        this(new char[][]{topLevelPackageName}, null, environment);
    }

    public PackageBinding(char[][] compoundName, PackageBinding parent, LookupEnvironment environment) {
        this.compoundName = compoundName;
        this.parent = parent;
        this.environment = environment;
        this.knownTypes = null;
        this.knownPackages = new HashtableOfPackage(3);
        if (compoundName != CharOperation.NO_CHAR_CHAR) {
            this.checkIfNullAnnotationPackage();
        }
    }

    public PackageBinding(LookupEnvironment environment) {
        this(CharOperation.NO_CHAR_CHAR, null, environment);
    }

    private void addNotFoundPackage(char[] simpleName) {
        this.knownPackages.put(simpleName, LookupEnvironment.TheNotFoundPackage);
    }

    private void addNotFoundType(char[] simpleName) {
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(simpleName, LookupEnvironment.TheNotFoundType);
    }

    void addPackage(PackageBinding element) {
        if ((element.tagBits & 0x80L) == 0L) {
            this.clearMissingTagBit();
        }
        this.knownPackages.put(element.compoundName[element.compoundName.length - 1], element);
    }

    void addType(ReferenceBinding element) {
        char[] name;
        ReferenceBinding priorType;
        if ((element.tagBits & 0x80L) == 0L) {
            this.clearMissingTagBit();
        }
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        if ((priorType = this.knownTypes.getput(name = element.compoundName[element.compoundName.length - 1], element)) != null && priorType.isUnresolvedType() && !element.isUnresolvedType()) {
            ((UnresolvedReferenceBinding)priorType).setResolvedType(element, this.environment);
        }
        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled && (element.isAnnotationType() || element instanceof UnresolvedReferenceBinding)) {
            this.checkIfNullAnnotationType(element);
        }
    }

    void clearMissingTagBit() {
        PackageBinding current = this;
        do {
            current.tagBits &= 0xFFFFFFFFFFFFFF7FL;
        } while ((current = current.parent) != null);
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        return CharOperation.concatWith(this.compoundName, '/');
    }

    private PackageBinding findPackage(char[] name) {
        if (!this.environment.isPackage(this.compoundName, name)) {
            return null;
        }
        char[][] subPkgCompoundName = CharOperation.arrayConcat(this.compoundName, name);
        PackageBinding subPackageBinding = new PackageBinding(subPkgCompoundName, this, this.environment);
        this.addPackage(subPackageBinding);
        return subPackageBinding;
    }

    PackageBinding getPackage(char[] name) {
        PackageBinding binding = this.getPackage0(name);
        if (binding != null) {
            if (binding == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return binding;
        }
        binding = this.findPackage(name);
        if (binding != null) {
            return binding;
        }
        this.addNotFoundPackage(name);
        return null;
    }

    PackageBinding getPackage0(char[] name) {
        return this.knownPackages.get(name);
    }

    ReferenceBinding getType(char[] name) {
        ReferenceBinding referenceBinding = this.getType0(name);
        if (referenceBinding == null && (referenceBinding = this.environment.askForType(this, name)) == null) {
            this.addNotFoundType(name);
            return null;
        }
        if (referenceBinding == LookupEnvironment.TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false)).isNestedType()) {
            return new ProblemReferenceBinding(new char[][]{name}, referenceBinding, 4);
        }
        return referenceBinding;
    }

    ReferenceBinding getType0(char[] name) {
        if (this.knownTypes == null) {
            return null;
        }
        return this.knownTypes.get(name);
    }

    public Binding getTypeOrPackage(char[] name) {
        PackageBinding packageBinding;
        ReferenceBinding referenceBinding = this.getType0(name);
        if (referenceBinding != null && referenceBinding != LookupEnvironment.TheNotFoundType) {
            if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false)).isNestedType()) {
                return new ProblemReferenceBinding(new char[][]{name}, referenceBinding, 4);
            }
            if ((referenceBinding.tagBits & 0x80L) == 0L) {
                return referenceBinding;
            }
        }
        if ((packageBinding = this.getPackage0(name)) != null && packageBinding != LookupEnvironment.TheNotFoundPackage) {
            return packageBinding;
        }
        if (packageBinding == null) {
            packageBinding = this.findPackage(name);
            if (packageBinding != null) {
                return packageBinding;
            }
            if (referenceBinding != null && referenceBinding != LookupEnvironment.TheNotFoundType) {
                return referenceBinding;
            }
            this.addNotFoundPackage(name);
        }
        if (referenceBinding == null) {
            referenceBinding = this.environment.askForType(this, name);
            if (referenceBinding != null) {
                if (referenceBinding.isNestedType()) {
                    return new ProblemReferenceBinding(new char[][]{name}, referenceBinding, 4);
                }
                return referenceBinding;
            }
            this.addNotFoundType(name);
        }
        return null;
    }

    public final boolean isViewedAsDeprecated() {
        if ((this.tagBits & 0x400000000L) == 0L) {
            ReferenceBinding packageInfo;
            this.tagBits |= 0x400000000L;
            if (this.compoundName != CharOperation.NO_CHAR_CHAR && (packageInfo = this.getType(TypeConstants.PACKAGE_INFO_NAME)) != null) {
                packageInfo.initializeDeprecatedAnnotationTagBits();
                this.tagBits |= packageInfo.tagBits & 0x17FFFFF800000000L;
            }
        }
        return (this.tagBits & 0x400000000000L) != 0L;
    }

    @Override
    public final int kind() {
        return 16;
    }

    @Override
    public int problemId() {
        if ((this.tagBits & 0x80L) != 0L) {
            return 1;
        }
        return 0;
    }

    void checkIfNullAnnotationPackage() {
        LookupEnvironment env = this.environment;
        if (env.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            if (this.isPackageOfQualifiedTypeName(this.compoundName, env.getNullableAnnotationName())) {
                env.nullableAnnotationPackage = this;
            }
            if (this.isPackageOfQualifiedTypeName(this.compoundName, env.getNonNullAnnotationName())) {
                env.nonnullAnnotationPackage = this;
            }
            if (this.isPackageOfQualifiedTypeName(this.compoundName, env.getNonNullByDefaultAnnotationName())) {
                env.nonnullByDefaultAnnotationPackage = this;
            }
        }
    }

    private boolean isPackageOfQualifiedTypeName(char[][] packageName, char[][] typeName) {
        int length;
        if (typeName == null || (length = packageName.length) != typeName.length - 1) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!CharOperation.equals(packageName[i], typeName[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void checkIfNullAnnotationType(ReferenceBinding type) {
        if (this.environment.nullableAnnotationPackage == this && CharOperation.equals(type.compoundName, this.environment.getNullableAnnotationName())) {
            type.typeBits |= 0x40;
            if (!(type instanceof UnresolvedReferenceBinding)) {
                this.environment.nullableAnnotationPackage = null;
            }
        } else if (this.environment.nonnullAnnotationPackage == this && CharOperation.equals(type.compoundName, this.environment.getNonNullAnnotationName())) {
            type.typeBits |= 0x20;
            if (!(type instanceof UnresolvedReferenceBinding)) {
                this.environment.nonnullAnnotationPackage = null;
            }
        } else if (this.environment.nonnullByDefaultAnnotationPackage == this && CharOperation.equals(type.compoundName, this.environment.getNonNullByDefaultAnnotationName())) {
            type.typeBits |= 0x80;
            if (!(type instanceof UnresolvedReferenceBinding)) {
                this.environment.nonnullByDefaultAnnotationPackage = null;
            }
        } else {
            type.typeBits |= this.environment.getNullAnnotationBit(type.compoundName);
        }
    }

    @Override
    public char[] readableName() {
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public String toString() {
        String str = this.compoundName == CharOperation.NO_CHAR_CHAR ? "The Default Package" : "package " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
        if ((this.tagBits & 0x80L) != 0L) {
            str = String.valueOf(str) + "[MISSING]";
        }
        return str;
    }
}

