/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.resource.common.DeferredReleaseSynchronization;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Uid;
import java.util.List;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContextHelper {
    private static final Logger log = LoggerFactory.getLogger(TransactionContextHelper.class);

    public static void enlistInCurrentTransaction(XAResourceHolder xaResourceHolder) throws SystemException, RollbackException {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        ResourceBean bean = xaResourceHolder.getResourceBean();
        if (log.isDebugEnabled()) {
            log.debug("enlisting " + xaResourceHolder + " into " + currentTransaction);
        }
        if (currentTransaction != null) {
            if (currentTransaction.timedOut()) {
                throw new BitronixSystemException("transaction timed out");
            }
            XAResourceHolderState alreadyEnlistedXAResourceHolderState = TransactionContextHelper.getLatestAlreadyEnlistedXAResourceHolderState(xaResourceHolder, currentTransaction);
            if (alreadyEnlistedXAResourceHolderState == null || alreadyEnlistedXAResourceHolderState.isEnded()) {
                currentTransaction.enlistResource(xaResourceHolder.getXAResource());
            } else if (log.isDebugEnabled()) {
                log.debug("avoiding re-enlistment of already enlisted but not ended resource " + alreadyEnlistedXAResourceHolderState);
            }
        } else if (bean.getAllowLocalTransactions()) {
            if (log.isDebugEnabled()) {
                log.debug("in local transaction context, skipping enlistment");
            }
        } else {
            throw new BitronixSystemException("resource '" + bean.getUniqueName() + "' cannot be used outside XA " + "transaction scope. Set allowLocalTransactions to true if you want to allow this and you know " + "your resource supports this.");
        }
    }

    public static void delistFromCurrentTransaction(XAResourceHolder xaResourceHolder) throws SystemException {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        ResourceBean bean = xaResourceHolder.getResourceBean();
        if (log.isDebugEnabled()) {
            log.debug("delisting " + xaResourceHolder + " from " + currentTransaction);
        }
        if (TransactionContextHelper.isInEnlistingGlobalTransactionContext(xaResourceHolder, currentTransaction) && !bean.getDeferConnectionRelease()) {
            Map<Uid, XAResourceHolderState> statesForGtrid = xaResourceHolder.getXAResourceHolderStatesForGtrid(currentTransaction.getResourceManager().getGtrid());
            for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
                if (!xaResourceHolderState.isEnded()) {
                    if (log.isDebugEnabled()) {
                        log.debug("delisting resource " + xaResourceHolderState + " from " + currentTransaction);
                    }
                    currentTransaction.delistResource(xaResourceHolderState.getXAResource(), 0x4000000);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("avoiding delistment of not enlisted resource " + xaResourceHolderState);
            }
        }
    }

    public static BitronixTransaction currentTransaction() {
        if (!TransactionManagerServices.isTransactionManagerRunning()) {
            return null;
        }
        return TransactionManagerServices.getTransactionManager().getCurrentTransaction();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void requeue(XAStatefulHolder xaStatefulHolder, ResourceBean bean) throws BitronixSystemException {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("requeuing " + xaStatefulHolder + " from " + currentTransaction);
        }
        if (!TransactionContextHelper.isInEnlistingGlobalTransactionContext(xaStatefulHolder, currentTransaction)) {
            if (TransactionContextHelper.isEnlistedInSomeTransaction(xaStatefulHolder)) throw new BitronixSystemException("cannot close a resource when its XAResource is taking part in an unfinished global transaction");
            if (log.isDebugEnabled()) {
                log.debug("resource not in enlisting global transaction context, immediately releasing to pool " + xaStatefulHolder);
            }
            xaStatefulHolder.setState(1);
            return;
        } else if (bean.getDeferConnectionRelease()) {
            if (log.isDebugEnabled()) {
                log.debug("deferring release to pool of " + xaStatefulHolder);
            }
            if (!TransactionContextHelper.isAlreadyRegisteredForDeferredRelease(xaStatefulHolder, currentTransaction)) {
                if (log.isDebugEnabled()) {
                    log.debug("registering DeferredReleaseSynchronization for " + xaStatefulHolder);
                }
                DeferredReleaseSynchronization synchronization = new DeferredReleaseSynchronization(xaStatefulHolder);
                currentTransaction.getSynchronizationScheduler().add(synchronization, Scheduler.ALWAYS_LAST_POSITION);
            } else if (log.isDebugEnabled()) {
                log.debug("already registered DeferredReleaseSynchronization for " + xaStatefulHolder);
            }
            xaStatefulHolder.setState(3);
            return;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("immediately releasing to pool " + xaStatefulHolder);
            }
            xaStatefulHolder.setState(1);
        }
    }

    public static void recycle(XAStatefulHolder xaStatefulHolder) {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("marking " + xaStatefulHolder + " as recycled in " + currentTransaction);
        }
        Scheduler<Synchronization> synchronizationScheduler = currentTransaction.getSynchronizationScheduler();
        DeferredReleaseSynchronization deferredReleaseSynchronization = TransactionContextHelper.findDeferredRelease(xaStatefulHolder, currentTransaction);
        if (deferredReleaseSynchronization != null) {
            if (log.isDebugEnabled()) {
                log.debug(xaStatefulHolder + " has been recycled, unregistering deferred release from " + currentTransaction);
            }
            synchronizationScheduler.remove(deferredReleaseSynchronization);
        }
    }

    private static boolean isAlreadyRegisteredForDeferredRelease(XAStatefulHolder xaStatefulHolder, BitronixTransaction currentTransaction) {
        boolean alreadyDeferred;
        boolean bl = alreadyDeferred = TransactionContextHelper.findDeferredRelease(xaStatefulHolder, currentTransaction) != null;
        if (log.isDebugEnabled()) {
            log.debug(xaStatefulHolder + " is " + (alreadyDeferred ? "" : "not ") + "already registered for deferred release in " + currentTransaction);
        }
        return alreadyDeferred;
    }

    private static DeferredReleaseSynchronization findDeferredRelease(XAStatefulHolder xaStatefulHolder, BitronixTransaction currentTransaction) {
        Scheduler<Synchronization> synchronizationScheduler = currentTransaction.getSynchronizationScheduler();
        for (Synchronization synchronization : synchronizationScheduler) {
            DeferredReleaseSynchronization deferredReleaseSynchronization;
            if (!(synchronization instanceof DeferredReleaseSynchronization) || (deferredReleaseSynchronization = (DeferredReleaseSynchronization)synchronization).getXAStatefulHolder() != xaStatefulHolder) continue;
            return deferredReleaseSynchronization;
        }
        return null;
    }

    private static boolean isEnlistedInSomeTransaction(XAResourceHolder xaResourceHolder) throws BitronixSystemException {
        if (log.isDebugEnabled()) {
            log.debug("looking in in-flight transactions for XAResourceHolderState of " + xaResourceHolder);
        }
        if (!TransactionManagerServices.isTransactionManagerRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("transaction manager not running, there is no in-flight transaction");
            }
            return false;
        }
        return xaResourceHolder.hasStateForXAResource(xaResourceHolder);
    }

    private static boolean isEnlistedInSomeTransaction(XAStatefulHolder xaStatefulHolder) throws BitronixSystemException {
        List<XAResourceHolder> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
        if (xaResourceHolders == null) {
            return false;
        }
        for (XAResourceHolder xaResourceHolder : xaResourceHolders) {
            boolean enlisted = TransactionContextHelper.isEnlistedInSomeTransaction(xaResourceHolder);
            if (!enlisted) continue;
            return true;
        }
        return false;
    }

    private static boolean isInEnlistingGlobalTransactionContext(XAResourceHolder xaResourceHolder, BitronixTransaction currentTransaction) {
        boolean globalTransactionMode = false;
        if (currentTransaction != null && xaResourceHolder.getXAResourceHolderStatesForGtrid(currentTransaction.getResourceManager().getGtrid()) != null) {
            globalTransactionMode = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("resource is " + (globalTransactionMode ? "" : "not ") + "in enlisting global transaction context: " + xaResourceHolder);
        }
        return globalTransactionMode;
    }

    private static boolean isInEnlistingGlobalTransactionContext(XAStatefulHolder xaStatefulHolder, BitronixTransaction currentTransaction) {
        List<XAResourceHolder> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
        if (xaResourceHolders == null) {
            return false;
        }
        for (XAResourceHolder xaResourceHolder : xaResourceHolders) {
            boolean enlisted = TransactionContextHelper.isInEnlistingGlobalTransactionContext(xaResourceHolder, currentTransaction);
            if (!enlisted) continue;
            return true;
        }
        return false;
    }

    private static XAResourceHolderState getLatestAlreadyEnlistedXAResourceHolderState(XAResourceHolder xaResourceHolder, BitronixTransaction currentTransaction) {
        if (currentTransaction == null) {
            return null;
        }
        Map<Uid, XAResourceHolderState> statesForGtrid = xaResourceHolder.getXAResourceHolderStatesForGtrid(currentTransaction.getResourceManager().getGtrid());
        if (statesForGtrid == null) {
            return null;
        }
        XAResourceHolderState result = null;
        for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
            if (xaResourceHolderState == null || xaResourceHolderState.getXid() == null) continue;
            BitronixXid bitronixXid = xaResourceHolderState.getXid();
            Uid resourceGtrid = bitronixXid.getGlobalTransactionIdUid();
            Uid currentTransactionGtrid = currentTransaction.getResourceManager().getGtrid();
            if (!currentTransactionGtrid.equals(resourceGtrid)) continue;
            result = xaResourceHolderState;
        }
        return result;
    }
}

