/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.List;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.OperatorDescr;

public class RelationalExprDescr
extends BaseDescr {
    private static final long serialVersionUID = 520L;
    private BaseDescr left;
    private BaseDescr right;
    private OperatorDescr operator;
    private String expression;

    public RelationalExprDescr() {
    }

    public RelationalExprDescr(String operator, boolean negated, List<String> parameters, BaseDescr left, BaseDescr right) {
        this.left = left;
        this.right = right;
        this.operator = new OperatorDescr(operator, negated, parameters);
    }

    public BaseDescr getLeft() {
        return this.left;
    }

    public void setLeft(BaseDescr left) {
        this.left = left;
    }

    public BaseDescr getRight() {
        return this.right;
    }

    public void setRight(BaseDescr right) {
        this.right = right;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getOperator() {
        return this.operator != null ? this.operator.getOperator() : null;
    }

    public void setOperator(String operator) {
        this.createOrGetOperator().setOperator(operator);
    }

    public boolean isNegated() {
        return this.operator != null ? this.operator.isNegated() : false;
    }

    public void setNegated(boolean negated) {
        this.createOrGetOperator().setNegated(negated);
    }

    public List<String> getParameters() {
        return this.operator != null ? this.operator.getParameters() : null;
    }

    public String getParametersText() {
        if (this.operator != null && this.operator.getParameters() != null) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String param : this.operator.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(param);
            }
            return builder.toString();
        }
        return null;
    }

    public void setParameters(List<String> parameters) {
        this.createOrGetOperator().setParameters(parameters);
    }

    private OperatorDescr createOrGetOperator() {
        if (this.operator == null) {
            this.operator = new OperatorDescr();
            this.operator.setResource(this.getResource());
        }
        return this.operator;
    }

    public OperatorDescr getOperatorDescr() {
        return this.operator;
    }

    public void setOperatorDescr(OperatorDescr operator) {
        this.operator = operator;
    }

    @Override
    public RelationalExprDescr replaceVariable(String oldVar, String newVar) {
        this.expression = this.expression.replace(oldVar, newVar);
        this.left = this.left.replaceVariable(oldVar, newVar);
        this.right = this.right.replaceVariable(oldVar, newVar);
        return this;
    }

    public String toString() {
        return this.left + (this.isNegated() ? " not " : " ") + this.getOperator() + (this.getParameters() != null ? this.getParameters().toString() + " " : " ") + this.right;
    }
}

