/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftlong;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class HardSoftLongScore
extends AbstractScore<HardSoftLongScore>
implements FeasibilityScore<HardSoftLongScore> {
    public static final HardSoftLongScore ZERO = new HardSoftLongScore(0, 0L, 0L);
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final long hardScore;
    private final long softScore;

    public static HardSoftLongScore parseScore(String scoreString) {
        String[] scoreTokens = HardSoftLongScore.parseScoreTokens(HardSoftLongScore.class, scoreString, HARD_LABEL, SOFT_LABEL);
        int initScore = HardSoftLongScore.parseInitScore(HardSoftLongScore.class, scoreString, scoreTokens[0]);
        long hardScore = HardSoftLongScore.parseLevelAsLong(HardSoftLongScore.class, scoreString, scoreTokens[1]);
        long softScore = HardSoftLongScore.parseLevelAsLong(HardSoftLongScore.class, scoreString, scoreTokens[2]);
        return HardSoftLongScore.ofUninitialized(initScore, hardScore, softScore);
    }

    public static HardSoftLongScore ofUninitialized(int initScore, long hardScore, long softScore) {
        return new HardSoftLongScore(initScore, hardScore, softScore);
    }

    @Deprecated
    public static HardSoftLongScore valueOfUninitialized(int initScore, long hardScore, long softScore) {
        return new HardSoftLongScore(initScore, hardScore, softScore);
    }

    public static HardSoftLongScore of(long hardScore, long softScore) {
        return new HardSoftLongScore(0, hardScore, softScore);
    }

    @Deprecated
    public static HardSoftLongScore valueOf(long hardScore, long softScore) {
        return new HardSoftLongScore(0, hardScore, softScore);
    }

    public static HardSoftLongScore ofHard(long hardScore) {
        return new HardSoftLongScore(0, hardScore, 0L);
    }

    public static HardSoftLongScore ofSoft(long softScore) {
        return new HardSoftLongScore(0, 0L, softScore);
    }

    private HardSoftLongScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = Long.MIN_VALUE;
        this.softScore = Long.MIN_VALUE;
    }

    private HardSoftLongScore(int initScore, long hardScore, long softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardSoftLongScore toInitializedScore() {
        return this.initScore == 0 ? this : new HardSoftLongScore(0, this.hardScore, this.softScore);
    }

    @Override
    public HardSoftLongScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new HardSoftLongScore(newInitScore, this.hardScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0L;
    }

    @Override
    public HardSoftLongScore add(HardSoftLongScore addend) {
        return new HardSoftLongScore(this.initScore + addend.getInitScore(), this.hardScore + addend.getHardScore(), this.softScore + addend.getSoftScore());
    }

    @Override
    public HardSoftLongScore subtract(HardSoftLongScore subtrahend) {
        return new HardSoftLongScore(this.initScore - subtrahend.getInitScore(), this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardSoftLongScore multiply(double multiplicand) {
        return new HardSoftLongScore((int)Math.floor((double)this.initScore * multiplicand), (long)Math.floor((double)this.hardScore * multiplicand), (long)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardSoftLongScore divide(double divisor) {
        return new HardSoftLongScore((int)Math.floor((double)this.initScore / divisor), (long)Math.floor((double)this.hardScore / divisor), (long)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardSoftLongScore power(double exponent) {
        return new HardSoftLongScore((int)Math.floor(Math.pow(this.initScore, exponent)), (long)Math.floor(Math.pow(this.hardScore, exponent)), (long)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardSoftLongScore negate() {
        return new HardSoftLongScore(-this.initScore, -this.hardScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftLongScore) {
            HardSoftLongScore other = (HardSoftLongScore)o;
            return this.initScore == other.getInitScore() && this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return ((629 + this.initScore) * 37 + Long.valueOf(this.hardScore).hashCode()) * 37 + Long.valueOf(this.softScore).hashCode();
    }

    @Override
    public int compareTo(HardSoftLongScore other) {
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        if (this.hardScore != other.getHardScore()) {
            return this.hardScore < other.getHardScore() ? -1 : 1;
        }
        return Long.compare(this.softScore, other.getSoftScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> (Long)n != 0L, HARD_LABEL, SOFT_LABEL);
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof HardSoftLongScore;
    }
}

