/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;

public final class ReflectionBeanPropertyMemberAccessor
implements MemberAccessor {
    private final Class<?> propertyType;
    private final String propertyName;
    private final Method getterMethod;
    private final Method setterMethod;

    public ReflectionBeanPropertyMemberAccessor(Method getterMethod) {
        this(getterMethod, false);
    }

    public ReflectionBeanPropertyMemberAccessor(Method getterMethod, boolean getterOnly) {
        this.getterMethod = getterMethod;
        getterMethod.setAccessible(true);
        Class<?> declaringClass = getterMethod.getDeclaringClass();
        if (!ReflectionHelper.isGetterMethod(getterMethod)) {
            throw new IllegalArgumentException("The getterMethod (" + getterMethod + ") is not a valid getter.");
        }
        this.propertyType = getterMethod.getReturnType();
        this.propertyName = ReflectionHelper.getGetterPropertyName(getterMethod);
        if (getterOnly) {
            this.setterMethod = null;
        } else {
            this.setterMethod = ReflectionHelper.getSetterMethod(declaringClass, getterMethod.getReturnType(), this.propertyName);
            if (this.setterMethod != null) {
                this.setterMethod.setAccessible(true);
            }
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getterMethod.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Class<?> getType() {
        return this.propertyType;
    }

    @Override
    public Type getGenericType() {
        return this.getterMethod.getGenericReturnType();
    }

    @Override
    public Object executeGetter(Object bean) {
        try {
            return this.getterMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call property (" + this.propertyName + ") getterMethod (" + this.getterMethod + ") on bean of class (" + bean.getClass() + ").", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The property (" + this.propertyName + ") getterMethod (" + this.getterMethod + ") on bean of class (" + bean.getClass() + ") throws an exception.", e.getCause());
        }
    }

    @Override
    public boolean supportSetter() {
        return this.setterMethod != null;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        try {
            this.setterMethod.invoke(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call property (" + this.propertyName + ") setterMethod (" + this.setterMethod + ") on bean of class (" + bean.getClass() + ") for value (" + value + ").", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The property (" + this.propertyName + ") setterMethod (" + this.setterMethod + ") on bean of class (" + bean.getClass() + ") throws an exception for value (" + value + ").", e.getCause());
        }
    }

    @Override
    public String getSpeedNote() {
        return "slow access with reflection";
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getterMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getterMethod.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getterMethod.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getterMethod.getDeclaredAnnotations();
    }

    public String toString() {
        return "bean property " + this.propertyName + " on " + this.getterMethod.getDeclaringClass();
    }
}

