/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.concurrent;

import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.api.concurrent.KieExecutors;

public class ExecutorProviderImpl
implements KieExecutors {
    public static final String EXECUTOR_SERVICE_PROPERTY = "drools.executorService";
    public static final String DEFAULT_JEE_EXECUTOR_SERVICE_NAME = "java:comp/env/concurrent/ThreadPool";
    public static final String THREAD_FACTORY_PROPERTY = "drools.threadFactory";

    public ExecutorService getExecutor() {
        return ExecutorHolder.executor;
    }

    public ExecutorService newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor(ExecutorHolder.threadFactory);
    }

    public ExecutorService newFixedThreadPool() {
        return this.newFixedThreadPool(KieExecutors.Pool.SIZE);
    }

    public ExecutorService newFixedThreadPool(int nThreads) {
        return Executors.newFixedThreadPool(nThreads, ExecutorHolder.threadFactory);
    }

    public <T> CompletionService<T> getCompletionService() {
        return new ExecutorCompletionService(this.getExecutor());
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger threadCount = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("drools-worker-" + threadCount.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    private static class ExecutorHolder {
        private static final ExecutorService executor;
        private static final ThreadFactory threadFactory;

        private ExecutorHolder() {
        }

        static {
            ExecutorService newExecutor;
            block7: {
                String threadFactoryClass = System.getProperty(ExecutorProviderImpl.THREAD_FACTORY_PROPERTY);
                if (threadFactoryClass == null) {
                    threadFactory = new DaemonThreadFactory();
                } else {
                    try {
                        threadFactory = (ThreadFactory)Class.forName(threadFactoryClass).newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to instance a ThreadFactory of class " + threadFactoryClass, e);
                    }
                }
                newExecutor = null;
                String executorServiceName = System.getProperty(ExecutorProviderImpl.EXECUTOR_SERVICE_PROPERTY);
                try {
                    InitialContext ctx = new InitialContext();
                    newExecutor = (ExecutorService)ctx.lookup(executorServiceName != null ? executorServiceName : ExecutorProviderImpl.DEFAULT_JEE_EXECUTOR_SERVICE_NAME);
                }
                catch (NamingException e) {
                    if (executorServiceName == null) break block7;
                    throw new RuntimeException("Unable to find an ExecutorService with JNDI name: " + executorServiceName, e);
                }
            }
            if (newExecutor == null) {
                newExecutor = new ThreadPoolExecutor(KieExecutors.Pool.SIZE, KieExecutors.Pool.SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            }
            executor = newExecutor;
        }
    }
}

