/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.ruleunit.State;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class RuleUnitDescriptionLoader {
    private State state = State.UNKNOWN;
    private final transient TypeResolver typeResolver;
    private final Map<String, RuleUnitDescription> ruleUnitDescriptionsCache = new ConcurrentHashMap<String, RuleUnitDescription>();
    private final Set<String> nonExistingUnits = new HashSet<String>();

    public RuleUnitDescriptionLoader(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public State getState() {
        return this.state;
    }

    public Map<String, RuleUnitDescription> getDescriptions() {
        return this.ruleUnitDescriptionsCache;
    }

    public Optional<RuleUnitDescription> getDescription(RuleImpl rule) {
        return this.getDescription(rule.getRuleUnitClassName());
    }

    public Optional<RuleUnitDescription> getDescription(String unitClassName) {
        Optional<RuleUnitDescription> result = Optional.ofNullable(unitClassName).map(name -> this.ruleUnitDescriptionsCache.computeIfAbsent((String)name, this::findDescription));
        this.state = this.state.hasUnit(result.isPresent());
        return result;
    }

    private RuleUnitDescription findDescription(String ruleUnit) {
        if (this.nonExistingUnits.contains(ruleUnit)) {
            return null;
        }
        try {
            return new RuleUnitDescription(this.typeResolver.resolveType(ruleUnit));
        }
        catch (ClassNotFoundException e) {
            this.nonExistingUnits.add(ruleUnit);
            return null;
        }
    }
}

