/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.date;

public enum DayOfWeek {
    SUNDAY,
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY;

    private static final DayOfWeek[] days;

    public int getIndex() {
        return this.ordinal() + 1;
    }

    public static int nextIndex(int index) {
        return ++index <= 7 ? index : 1;
    }

    public static DayOfWeek[] getAll() {
        return days;
    }

    public static DayOfWeek getByName(String name) {
        try {
            return DayOfWeek.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DayOfWeek getByIndex(int index) {
        return days[index - 1];
    }

    static {
        days = DayOfWeek.values();
    }
}

