/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.def;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.validation.IsTimeInterval;
import org.dashbuilder.dataset.validation.groups.DataSetDefBasicAttributesGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefCacheRowsValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefProviderTypeGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefPushSizeValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefRefreshIntervalValidation;

public class DataSetDef {
    @NotNull(groups={DataSetDefBasicAttributesGroup.class})
    @Size(min=1, groups={DataSetDefBasicAttributesGroup.class})
    protected String UUID;
    @NotNull(groups={DataSetDefBasicAttributesGroup.class})
    @Size(min=1, groups={DataSetDefBasicAttributesGroup.class})
    protected String name;
    @NotNull(groups={DataSetDefProviderTypeGroup.class})
    protected DataSetProviderType provider;
    protected List<DataColumnDef> columns = new ArrayList<DataColumnDef>();
    protected DataSetFilter dataSetFilter = null;
    protected boolean isPublic = true;
    protected boolean pushEnabled = false;
    @NotNull(groups={DataSetDefPushSizeValidation.class})
    @Max(value=4096L)
    protected Integer pushMaxSize = 1024;
    protected boolean cacheEnabled = false;
    @NotNull(groups={DataSetDefCacheRowsValidation.class})
    @Max(value=10000L)
    protected Integer cacheMaxRows = 1000;
    @NotNull(groups={DataSetDefRefreshIntervalValidation.class})
    @Size(min=1, groups={DataSetDefRefreshIntervalValidation.class})
    @IsTimeInterval(groups={DataSetDefRefreshIntervalValidation.class})
    protected String refreshTime = null;
    protected boolean refreshAlways = false;
    protected boolean allColumnsEnabled = true;
    protected Map<String, String> patternMap = new HashMap<String, String>();
    protected Map<String, String> propertyMap = new HashMap<String, String>();

    public String getUUID() {
        return this.UUID;
    }

    public void setUUID(String UUID) {
        this.UUID = UUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSetFilter getDataSetFilter() {
        return this.dataSetFilter;
    }

    public void setDataSetFilter(DataSetFilter dataSetFilter) {
        this.dataSetFilter = dataSetFilter;
        if (dataSetFilter != null) {
            this.dataSetFilter.setDataSetUUID(this.UUID);
        }
    }

    public DataSetProviderType getProvider() {
        return this.provider;
    }

    public void setProvider(DataSetProviderType provider) {
        this.provider = provider;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public void setPushEnabled(boolean pushEnabled) {
        this.pushEnabled = pushEnabled;
    }

    public Integer getPushMaxSize() {
        return this.pushMaxSize;
    }

    public void setPushMaxSize(Integer pushMaxSize) {
        this.pushMaxSize = pushMaxSize;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public Integer getCacheMaxRows() {
        return this.cacheMaxRows;
    }

    public void setCacheMaxRows(Integer cacheMaxRows) {
        this.cacheMaxRows = cacheMaxRows;
    }

    public String getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(String refreshTime) {
        this.refreshTime = refreshTime;
    }

    public TimeAmount getRefreshTimeAmount() {
        if (this.refreshTime != null && this.refreshTime.trim().length() > 0) {
            return TimeAmount.parse(this.refreshTime);
        }
        return null;
    }

    public boolean isRefreshAlways() {
        return this.refreshAlways;
    }

    public void setRefreshAlways(boolean refreshAlways) {
        this.refreshAlways = refreshAlways;
    }

    public String getPattern(String columnId) {
        return this.patternMap.get(columnId);
    }

    public void setPattern(String columnId, String pattern) {
        this.patternMap.put(columnId, pattern);
    }

    public boolean isAllColumnsEnabled() {
        return this.allColumnsEnabled;
    }

    public void setAllColumnsEnabled(boolean allColumnsEnabled) {
        this.allColumnsEnabled = allColumnsEnabled;
    }

    public List<DataColumnDef> getColumns() {
        return this.columns;
    }

    public void setColumns(List<DataColumnDef> columns) {
        this.columns = columns;
    }

    public DataColumnDef getColumnById(String id) {
        if (id != null && this.columns != null && !this.columns.isEmpty()) {
            for (DataColumnDef columnDef : this.columns) {
                if (!columnDef.getId().equalsIgnoreCase(id)) continue;
                return columnDef;
            }
        }
        return null;
    }

    public boolean addColumn(String id, ColumnType type) {
        if (this.columns == null) {
            this.columns = new LinkedList<DataColumnDef>();
        }
        return this.columns.add(new DataColumnDef(id, type));
    }

    public Set<String> getPropertyNames() {
        return this.propertyMap.keySet();
    }

    public String getProperty(String key) {
        return this.propertyMap.get(key);
    }

    public void setProperty(String key, String value) {
        this.propertyMap.put(key, value);
    }

    public DataSetDef clone() {
        DataSetDef def = new DataSetDef();
        this.clone(def);
        return def;
    }

    protected void clone(DataSetDef def) {
        def.setUUID(this.getUUID());
        def.setName(this.getName());
        def.setProvider(this.getProvider());
        def.setPublic(this.isPublic());
        DataSetFilter currentFilter = this.getDataSetFilter();
        if (currentFilter != null) {
            DataSetFilter nFilter = currentFilter.cloneInstance();
            nFilter.setDataSetUUID(this.getUUID());
            def.setDataSetFilter(nFilter);
        }
        def.setDataSetFilter(this.getDataSetFilter());
        def.setCacheEnabled(this.isCacheEnabled());
        def.setCacheMaxRows(this.getCacheMaxRows());
        def.setPushEnabled(this.isPushEnabled());
        def.setPushMaxSize(this.getPushMaxSize());
        def.setRefreshAlways(this.isRefreshAlways());
        def.setRefreshTime(this.getRefreshTime());
        def.setAllColumnsEnabled(this.isAllColumnsEnabled());
        List<DataColumnDef> columns = this.getColumns();
        if (columns != null && !columns.isEmpty()) {
            LinkedList<DataColumnDef> c = new LinkedList<DataColumnDef>();
            for (DataColumnDef columnDef : columns) {
                DataColumnDef _c = columnDef.clone();
                c.add(_c);
            }
            def.setColumns(c);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getUUID() == null) {
            return false;
        }
        try {
            DataSetDef other = (DataSetDef)obj;
            if (this.UUID != null && !this.UUID.equals(other.UUID)) {
                return false;
            }
            if (this.provider != null && !this.provider.equals(other.provider)) {
                return false;
            }
            if (this.name != null && !this.name.equals(other.name)) {
                return false;
            }
            if (this.isPublic != other.isPublic) {
                return false;
            }
            if (this.allColumnsEnabled != other.allColumnsEnabled) {
                return false;
            }
            if (this.pushEnabled != other.pushEnabled) {
                return false;
            }
            if (this.pushMaxSize != null && !this.pushMaxSize.equals(other.pushMaxSize)) {
                return false;
            }
            if (this.cacheEnabled != other.cacheEnabled) {
                return false;
            }
            if (this.cacheMaxRows != null && !this.cacheMaxRows.equals(other.cacheMaxRows)) {
                return false;
            }
            if (this.columns.size() != other.columns.size()) {
                return false;
            }
            if (this.refreshTime != null && !this.refreshTime.equals(other.refreshTime)) {
                return false;
            }
            if (this.refreshAlways != other.refreshAlways) {
                return false;
            }
            if (this.dataSetFilter != null && !this.dataSetFilter.equals(other.dataSetFilter)) {
                return false;
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                DataColumnDef otherEl;
                DataColumnDef el = this.columns.get(i);
                if (el.equals(otherEl = other.columns.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.UUID, this.name, this.provider, this.columns, this.dataSetFilter, this.isPublic, this.pushEnabled, this.pushMaxSize, this.cacheEnabled, this.cacheMaxRows, this.refreshTime, this.refreshAlways, this.allColumnsEnabled, this.patternMap, this.propertyMap);
    }
}

