/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshallerExt;
import org.dashbuilder.json.JsonObject;

public class CSVDefJSONMarshaller
implements DataSetDefJSONMarshallerExt<CSVDataSetDef> {
    public static CSVDefJSONMarshaller INSTANCE = new CSVDefJSONMarshaller();
    public static final String FILEURL = "fileURL";
    public static final String FILEPATH = "filePath";
    public static final String SEPARATORCHAR = "separatorChar";
    public static final String QUOTECHAR = "quoteChar";
    public static final String ESCAPECHAR = "escapeChar";
    public static final String DATEPATTERN = "datePattern";
    public static final String NUMBERPATTERN = "numberPattern";

    @Override
    public void fromJson(CSVDataSetDef def, JsonObject json) {
        String fileURL = json.getString(FILEURL);
        String filePath = json.getString(FILEPATH);
        String separatorChar = this.parseCodePoint(json.getString(SEPARATORCHAR));
        String quoteChar = this.parseCodePoint(json.getString(QUOTECHAR));
        String escapeChar = this.parseCodePoint(json.getString(ESCAPECHAR));
        String datePattern = json.getString(DATEPATTERN);
        String numberPattern = json.getString(NUMBERPATTERN);
        if (!DataSetDefJSONMarshaller.isBlank(fileURL)) {
            def.setFileURL(fileURL);
        }
        if (!DataSetDefJSONMarshaller.isBlank(filePath)) {
            def.setFilePath(filePath);
        }
        if (!DataSetDefJSONMarshaller.isBlank(separatorChar)) {
            def.setSeparatorChar(Character.valueOf(separatorChar.charAt(0)));
        }
        if (!DataSetDefJSONMarshaller.isBlank(quoteChar)) {
            def.setQuoteChar(Character.valueOf(quoteChar.charAt(0)));
        }
        if (!DataSetDefJSONMarshaller.isBlank(escapeChar)) {
            def.setEscapeChar(Character.valueOf(escapeChar.charAt(0)));
        }
        if (!DataSetDefJSONMarshaller.isBlank(numberPattern)) {
            def.setNumberPattern(numberPattern);
        }
        if (!DataSetDefJSONMarshaller.isBlank(datePattern)) {
            def.setDatePattern(datePattern);
        }
    }

    public String parseCodePoint(String codePoint) {
        try {
            if (!DataSetDefJSONMarshaller.isBlank(codePoint)) {
                return String.valueOf(Character.toChars(Integer.parseInt(codePoint)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codePoint;
    }

    @Override
    public void toJson(CSVDataSetDef dataSetDef, JsonObject json) {
        if (dataSetDef.getFilePath() != null) {
            json.put(FILEPATH, dataSetDef.getFilePath());
        }
        if (dataSetDef.getFileURL() != null) {
            json.put(FILEURL, dataSetDef.getFileURL());
        }
        json.put(SEPARATORCHAR, String.valueOf(dataSetDef.getSeparatorChar()));
        json.put(QUOTECHAR, String.valueOf(dataSetDef.getQuoteChar()));
        json.put(ESCAPECHAR, String.valueOf(dataSetDef.getEscapeChar()));
        json.put(DATEPATTERN, dataSetDef.getDatePattern());
        json.put(NUMBERPATTERN, dataSetDef.getNumberPattern());
        json.put("allColumns", dataSetDef.isAllColumnsEnabled());
    }
}

