/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.api.conf.Option;
import org.kie.dmn.api.core.AfterGeneratingSourcesListener;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.core.compiler.CoerceDecisionServiceSingletonOutputOption;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.compiler.ExecModelCompilerOption;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.util.ClassLoaderUtil;

public class DMNCompilerConfigurationImpl
implements DMNCompilerConfiguration {
    private List<DMNExtensionRegister> registeredExtensions = new ArrayList<DMNExtensionRegister>();
    private Map<String, String> properties = new HashMap<String, String>();
    private List<DRGElementCompiler> drgElementCompilers = new ArrayList<DRGElementCompiler>();
    private List<FEELProfile> feelProfiles = new ArrayList<FEELProfile>();
    private ClassLoader rootClassLoader = ClassLoaderUtil.findDefaultClassLoader();
    private List<AfterGeneratingSourcesListener> listeners = new ArrayList<AfterGeneratingSourcesListener>();
    private Boolean deferredCompilation = false;

    public void addExtensions(List<DMNExtensionRegister> extensionRegisters) {
        this.registeredExtensions.addAll(extensionRegisters);
    }

    public void addExtension(DMNExtensionRegister extensionRegister) {
        this.registeredExtensions.add(extensionRegister);
    }

    public void addListener(AfterGeneratingSourcesListener listener) {
        this.listeners.add(listener);
    }

    public List<AfterGeneratingSourcesListener> getAfterGeneratingSourcesListeners() {
        return this.listeners;
    }

    public List<DMNExtensionRegister> getRegisteredExtensions() {
        return this.registeredExtensions;
    }

    public void setProperties(Map<String, String> dmnPrefs) {
        this.properties.putAll(dmnPrefs);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public final <T extends Option> T getOption(Class<T> option) {
        if (RuntimeTypeCheckOption.class.equals(option)) {
            return (T)new RuntimeTypeCheckOption(this.properties.get("org.kie.dmn.runtime.typecheck"));
        }
        if (CoerceDecisionServiceSingletonOutputOption.class.equals(option)) {
            return (T)new CoerceDecisionServiceSingletonOutputOption(this.properties.get("org.kie.dmn.decisionservice.coercesingleton"));
        }
        if (ExecModelCompilerOption.class.equals(option)) {
            return (T)new ExecModelCompilerOption(this.properties.get("org.kie.dmn.compiler.execmodel"));
        }
        return null;
    }

    public void addDRGElementCompilers(List<DRGElementCompiler> drgElementCompilers) {
        this.drgElementCompilers.addAll(drgElementCompilers);
    }

    public List<DRGElementCompiler> getDRGElementCompilers() {
        return this.drgElementCompilers;
    }

    public List<FEELProfile> getFeelProfiles() {
        return this.feelProfiles;
    }

    public void addFEELProfile(FEELProfile dmnProfile) {
        this.feelProfiles.add(dmnProfile);
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public void setRootClassLoader(ClassLoader classLoader) {
        this.rootClassLoader = classLoader;
    }

    public boolean isUseExecModelCompiler() {
        return this.getOption(ExecModelCompilerOption.class).isUseExecModelCompiler();
    }

    public boolean isDeferredCompilation() {
        return this.deferredCompilation;
    }

    public void setDeferredCompilation(Boolean deferredCompilation) {
        this.deferredCompilation = deferredCompilation;
    }
}

