/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.core.common.ProjectClassLoader;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.kie.api.runtime.rule.DataSource;
import org.kie.dmn.api.core.GeneratedSource;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.execmodelbased.AbstractModelEvaluator;
import org.kie.dmn.core.compiler.execmodelbased.CompiledDTTest;
import org.kie.dmn.core.compiler.execmodelbased.DMNUnit;
import org.kie.dmn.core.compiler.execmodelbased.DTableModel;
import org.kie.dmn.core.compiler.execmodelbased.DecisionTableEvaluator;
import org.kie.dmn.core.compiler.execmodelbased.FeelExpressionSourceGenerator;
import org.kie.dmn.core.compiler.execmodelbased.FeelValue;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.internal.jci.CompilationProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecModelDMNEvaluatorCompiler
extends DMNEvaluatorCompiler {
    static final Logger logger = LoggerFactory.getLogger(ExecModelDMNEvaluatorCompiler.class);
    private GeneratorsEnum[] GENERATORS_WITHOUT_EXPRESSIONS = new GeneratorsEnum[]{GeneratorsEnum.EVALUATOR, GeneratorsEnum.UNIT, GeneratorsEnum.EXEC_MODEL, GeneratorsEnum.UNARY_TESTS};
    private ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader();

    public ExecModelDMNEvaluatorCompiler(DMNCompilerImpl compiler) {
        super(compiler);
    }

    @Override
    protected DMNExpressionEvaluator compileDecisionTable(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String dtName, DecisionTable dt) {
        String decisionName = ExecModelDMNEvaluatorCompiler.getDecisionTableName(dtName, dt);
        DTableModel dTableModel = new DTableModel(ctx.getFeelHelper(), model, dtName, decisionName, dt);
        AbstractModelEvaluator evaluator = this.generateEvaluator(ctx, dTableModel);
        if (evaluator != null) {
            evaluator.initParameters(ctx.getFeelHelper(), ctx, dTableModel, node);
        }
        return evaluator;
    }

    protected static String getDecisionTableName(String dtName, DecisionTable dt) {
        String decisionName;
        if (dt.getParent() instanceof DRGElement) {
            decisionName = dtName;
        } else if (dt.getId() != null) {
            decisionName = dt.getId();
        } else {
            DecisionTable cursor = dt;
            ArrayList<String> path = new ArrayList<String>();
            while (!(cursor instanceof DRGElement)) {
                int indexOf = cursor.getParent().getChildren().indexOf(cursor);
                path.add(String.valueOf(indexOf));
                cursor = cursor.getParent();
            }
            path.add(((DRGElement)cursor).getName());
            decisionName = path.stream().sorted(Collections.reverseOrder()).collect(Collectors.joining("/"));
        }
        return decisionName;
    }

    public AbstractModelEvaluator generateEvaluator(DMNCompilerContext ctx, DTableModel dTableModel) {
        String pkgName = dTableModel.getNamespace();
        String clasName = dTableModel.getTableName();
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] fileNames = new String[this.getGenerators().length];
        ArrayList<GeneratedSource> generatedSources = new ArrayList<GeneratedSource>();
        this.generateSources(ctx, dTableModel, srcMfs, fileNames, generatedSources);
        this.compileGeneratedClass(srcMfs, trgMfs, fileNames);
        this.defineClassInClassLoader(trgMfs);
        return this.createInvoker(pkgName, clasName);
    }

    protected void generateSources(DMNCompilerContext ctx, DTableModel dTableModel, MemoryFileSystem srcMfs, String[] fileNames, List<GeneratedSource> generatedSources) {
        for (int i = 0; i < fileNames.length; ++i) {
            GeneratorsEnum generator = this.getGenerators()[i];
            String className = dTableModel.getGeneratedClassName(generator);
            String fileName = "src/main/java/" + className.replace('.', '/') + ".java";
            String javaSource = generator.sourceGenerator.generate(ctx, ctx.getFeelHelper(), dTableModel);
            fileNames[i] = fileName;
            generatedSources.add(new GeneratedSource(fileName, javaSource));
            srcMfs.write(fileNames[i], javaSource.getBytes());
        }
    }

    protected GeneratorsEnum[] getGenerators() {
        return this.GENERATORS_WITHOUT_EXPRESSIONS;
    }

    private AbstractModelEvaluator createInvoker(String pkgName, String clasName) {
        try {
            Class evalClass = this.projectClassLoader.loadClass(pkgName + "." + clasName + "Evaluator");
            return (AbstractModelEvaluator)evalClass.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unknown decision table: " + clasName, e);
        }
    }

    private void defineClassInClassLoader(MemoryFileSystem trgMfs) {
        trgMfs.getFileNames().stream().forEach(f -> this.projectClassLoader.defineClass(f.replace('/', '.').substring(0, f.length() - ".class".length()), trgMfs.getBytes(f)));
    }

    private void compileGeneratedClass(MemoryFileSystem srcMfs, MemoryFileSystem trgMfs, String[] fileNames) {
        CompilationResult res = JavaParserCompiler.getCompiler().compile(fileNames, (ResourceReader)srcMfs, (ResourceStore)trgMfs, (ClassLoader)this.projectClassLoader);
        CompilationProblem[] errors = res.getErrors();
        if (errors != null && errors.length > 0) {
            Stream.of(errors).forEach(System.err::println);
            throw new RuntimeException();
        }
    }

    public static class UnaryTestsSourceGenerator
    implements SourceGenerator {
        @Override
        public String generate(DMNCompilerContext ctx, DMNFEELHelper feel, DTableModel dTableModel) {
            String pkgName = dTableModel.getNamespace();
            String clasName = dTableModel.getTableName();
            StringBuilder sb = new StringBuilder();
            sb.append("package ").append(pkgName).append(";\n");
            sb.append("\n");
            sb.append("import java.util.List;\n");
            sb.append("import org.kie.dmn.feel.codegen.feel11.CompiledFEELUnaryTests;\n");
            sb.append("import org.kie.dmn.feel.codegen.feel11.CompiledFEELSupport;\n");
            sb.append("import org.kie.dmn.feel.codegen.feel11.CompiledCustomFEELFunction;\n");
            sb.append("import org.kie.dmn.feel.runtime.UnaryTest;\n");
            sb.append("import org.kie.dmn.feel.lang.EvaluationContext;\n");
            sb.append("import ").append(CompiledDTTest.class.getCanonicalName()).append(";\n");
            sb.append("import static org.kie.dmn.feel.codegen.feel11.CompiledFEELSemanticMappings.*;\n");
            sb.append("\n");
            sb.append("public class ").append(clasName).append("UnaryTests {\n");
            sb.append("\n");
            sb.append(this.getUnaryTestsSource(ctx, feel, dTableModel, pkgName, clasName));
            sb.append("}\n");
            String source = sb.toString();
            if (logger.isDebugEnabled()) {
                logger.debug(clasName + ":\n" + source);
            }
            return source;
        }

        public String getUnaryTestsSource(DMNCompilerContext ctx, DMNFEELHelper feel, DTableModel dTableModel, String pkgName, String className) {
            StringBuilder testArrayBuilder = new StringBuilder();
            StringBuilder testsBuilder = new StringBuilder();
            StringBuilder instancesBuilder = new StringBuilder();
            HashMap<String, String> testClassesByInput = new HashMap<String, String>();
            testArrayBuilder.append("    public static final CompiledDTTest[][] TEST_ARRAY = new CompiledDTTest[][] {\n");
            for (int i = 0; i < dTableModel.getRows().size(); ++i) {
                testArrayBuilder.append("            { ");
                DTableModel.DRowModel row = dTableModel.getRows().get(i);
                for (int j = 0; j < row.getInputs().size(); ++j) {
                    String input = row.getInputs().get(j);
                    String testClass = (String)testClassesByInput.get(input);
                    if (testClass == null) {
                        testClass = className + "r" + i + "c" + j;
                        testClassesByInput.put(input, testClass);
                        instancesBuilder.append("    private static final CompiledDTTest " + testClass + "_INSTANCE = new CompiledDTTest( new " + testClass + "() );\n");
                        String sourceCode = ((ClassOrInterfaceDeclaration)feel.generateUnaryTestsSource(input, ctx, dTableModel.getColumns().get(j).getType()).setName(testClass)).toString();
                        testsBuilder.append("\n");
                        testsBuilder.append(sourceCode);
                        testsBuilder.append("\n");
                    }
                    testArrayBuilder.append(testClass).append("_INSTANCE");
                    if (j >= row.getInputs().size() - 1) continue;
                    testArrayBuilder.append(", ");
                }
                if (i < dTableModel.getRows().size() - 1) {
                    testArrayBuilder.append(" },\n");
                    continue;
                }
                testArrayBuilder.append(" }\n");
            }
            testArrayBuilder.append("    };\n");
            return instancesBuilder + "\n" + testArrayBuilder + "\n" + testsBuilder;
        }
    }

    public static class UnitSourceGenerator
    implements SourceGenerator {
        @Override
        public String generate(DMNCompilerContext ctx, DMNFEELHelper feel, DTableModel dTableModel) {
            int i2;
            String pkgName = dTableModel.getNamespace();
            String clasName = dTableModel.getTableName();
            StringBuilder sb = new StringBuilder();
            sb.append("package ").append(pkgName).append(";\n");
            sb.append("\n");
            sb.append("import java.util.List;\n");
            sb.append("import java.util.ArrayList;\n");
            sb.append("import ").append(DataSource.class.getCanonicalName()).append(";\n");
            sb.append("\n");
            sb.append("public class ").append(clasName).append("DTUnit extends " + DMNUnit.class.getCanonicalName() + " {\n");
            for (i2 = 0; i2 < dTableModel.getInputSize(); ++i2) {
                sb.append("\n");
                sb.append("    private DataSource<Object> input").append(i2).append(";\n");
                sb.append("    public DataSource<Object> getInput").append(i2).append("() {\n");
                sb.append("        return input").append(i2).append(";\n");
                sb.append("    }\n");
            }
            for (i2 = 0; i2 < dTableModel.getOutputSize(); ++i2) {
                sb.append("\n");
                sb.append("    private List<Object> output" + i2 + " = new ArrayList<Object>();\n");
                sb.append("    public List<Object> getOutput" + i2 + "() {\n");
                sb.append("        return output" + i2 + ";\n");
                sb.append("    }\n");
            }
            sb.append("\n");
            sb.append("    @Override\n");
            sb.append("    public void onStart() {\n");
            for (i2 = 0; i2 < dTableModel.getInputSize(); ++i2) {
                sb.append("        input").append(i2).append(" = DataSource.create( getValue(").append(i2).append(") );\n");
            }
            sb.append("    }\n");
            sb.append("\n");
            sb.append("    @Override\n");
            sb.append("    public void onEnd() {\n");
            sb.append("        result = applyHitPolicy( ");
            sb.append(IntStream.range(0, dTableModel.getOutputSize()).mapToObj(i -> "output" + i).collect(Collectors.joining(", ")));
            sb.append(" );\n");
            sb.append("    }\n");
            sb.append("}\n");
            String source = sb.toString();
            if (logger.isDebugEnabled()) {
                logger.debug(clasName + ":\n" + source);
            }
            return source;
        }
    }

    public static class ExecModelSourceGenerator
    implements SourceGenerator {
        @Override
        public String generate(DMNCompilerContext ctx, DMNFEELHelper feel, DTableModel dTableModel) {
            int j2;
            String pkgName = dTableModel.getNamespace();
            String clasName = dTableModel.getTableName();
            StringBuilder sb = new StringBuilder();
            sb.append("package ").append(pkgName).append(";\n");
            sb.append("\n");
            sb.append("import java.util.List;\n");
            sb.append("import " + FeelValue.class.getCanonicalName() + ";\n");
            sb.append("import " + DecisionTableEvaluator.class.getCanonicalName() + ";\n");
            sb.append("import org.kie.api.runtime.rule.DataSource;\n");
            sb.append("import org.drools.model.*;\n");
            sb.append("import org.drools.modelcompiler.dsl.pattern.D;\n");
            sb.append("import static ").append(pkgName).append(".").append(clasName).append("UnaryTests.TEST_ARRAY;\n");
            sb.append("\n");
            sb.append("public class ").append(clasName).append("ExecModel {\n");
            sb.append("\n");
            sb.append("    public static List<Rule> getRules() {\n");
            sb.append("        return java.util.Arrays.asList( ");
            sb.append(IntStream.range(0, dTableModel.getRows().size()).mapToObj(i -> "rule_" + clasName + "_" + i + "()").collect(Collectors.joining(", ")));
            sb.append(" );\n");
            sb.append("    }\n");
            boolean exprCounter = false;
            sb.append("\n");
            sb.append("    private static final UnitData<DecisionTableEvaluator> var_evaluator = D.unitData(DecisionTableEvaluator.class, \"evaluator\");\n");
            for (j2 = 0; j2 < dTableModel.getOutputSize(); ++j2) {
                sb.append("    private static final UnitData<List> var_output" + j2 + " = D.unitData(List.class, \"output" + j2 + "\");\n");
            }
            for (j2 = 0; j2 < dTableModel.getInputSize(); ++j2) {
                sb.append("    private static final UnitData<DataSource> var_input" + j2 + " = D.unitData(DataSource.class, \"input" + j2 + "\");\n");
                sb.append("    private static final Variable<FeelValue> var_$pattern$" + j2 + "$ = D.declarationOf(FeelValue.class, \"$pattern$" + j2 + "$\", var_input" + j2 + ");\n");
            }
            for (int i2 = 0; i2 < dTableModel.getRows().size(); ++i2) {
                int j3;
                DTableModel.DRowModel row = dTableModel.getRows().get(i2);
                sb.append("\n");
                sb.append("    private static Rule rule_" + clasName + "_" + i2 + "() {\n");
                sb.append("        return D.rule(\"" + pkgName + "\", \"" + clasName + "_" + i2 + "\")\n");
                sb.append("                .unit(" + pkgName + "." + clasName + "DTUnit.class)\n");
                sb.append("                .build( \n");
                for (j3 = 0; j3 < dTableModel.getInputSize(); ++j3) {
                    sb.append("                       D.pattern(var_$pattern$" + j3 + "$).expr(TEST_ARRAY[" + i2 + "][" + j3 + "].getName(), var_evaluator,\n");
                    sb.append("                           (_this, evaluator) -> TEST_ARRAY[" + i2 + "][" + j3 + "].test( evaluator.getEvalCtx(" + j3 + "), _this.getValue() )),\n");
                }
                sb.append("                       D.on( var_evaluator, ");
                sb.append(IntStream.range(0, dTableModel.getOutputSize()).mapToObj(j -> "var_output" + j).collect(Collectors.joining(", ")));
                sb.append(" ).execute(( evaluator, ");
                sb.append(IntStream.range(0, dTableModel.getOutputSize()).mapToObj(j -> "output" + j).collect(Collectors.joining(", ")));
                sb.append(" ) -> {\n");
                for (j3 = 0; j3 < dTableModel.getOutputSize(); ++j3) {
                    sb.append("                            output" + j3 + ".add(evaluator.getOutput(" + i2 + ", " + j3 + "));\n");
                }
                sb.append("                            evaluator.registerFire(" + i2 + ");\n");
                sb.append("                       }\n");
                sb.append("        ));\n");
                sb.append("    }\n");
            }
            sb.append("}\n");
            String source = sb.toString();
            if (logger.isDebugEnabled()) {
                logger.debug(clasName + ":\n" + source);
            }
            return source;
        }
    }

    public static class EvaluatorSourceGenerator
    implements SourceGenerator {
        @Override
        public String generate(DMNCompilerContext ctx, DMNFEELHelper feel, DTableModel dTableModel) {
            String pkgName = dTableModel.getNamespace();
            String clasName = dTableModel.getTableName();
            StringBuilder sb = new StringBuilder();
            sb.append("package ").append(pkgName).append(";\n");
            sb.append("\n");
            sb.append("import java.util.List;\n");
            sb.append("import org.drools.model.Rule;\n");
            sb.append("import ").append(DMNUnit.class.getCanonicalName()).append(";\n");
            sb.append("\n");
            sb.append("public class ").append(clasName).append("Evaluator extends " + AbstractModelEvaluator.class.getCanonicalName() + "{\n");
            sb.append("\n");
            sb.append("    @Override\n");
            sb.append("    protected List<Rule> getRules() {\n");
            sb.append("        return ").append(clasName).append("ExecModel.getRules();\n");
            sb.append("    }\n");
            sb.append("\n");
            sb.append("    @Override\n");
            sb.append("    protected DMNUnit getDMNUnit() {\n");
            sb.append("        return new ").append(clasName).append("DTUnit();\n");
            sb.append("    }\n");
            sb.append("}\n");
            String source = sb.toString();
            if (logger.isDebugEnabled()) {
                logger.debug(clasName + ":\n" + source);
            }
            return source;
        }
    }

    static interface SourceGenerator {
        public String generate(DMNCompilerContext var1, DMNFEELHelper var2, DTableModel var3);
    }

    static enum GeneratorsEnum {
        EVALUATOR("Evaluator", new EvaluatorSourceGenerator()),
        UNIT("DTUnit", new UnitSourceGenerator()),
        EXEC_MODEL("ExecModel", new ExecModelSourceGenerator()),
        UNARY_TESTS("UnaryTests", new UnaryTestsSourceGenerator()),
        FEEL_EXPRESSION("FeelExpression", new FeelExpressionSourceGenerator());

        String type;
        SourceGenerator sourceGenerator;

        private GeneratorsEnum(String type, SourceGenerator sourceGenerator) {
            this.type = type;
            this.sourceGenerator = sourceGenerator;
        }
    }
}

