/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.util.EvalHelper;

public class CompositeTypeImpl
extends BaseDMNTypeImpl {
    private final Map<String, DMNType> fields;

    public CompositeTypeImpl() {
        this(null, null, null, false, new LinkedHashMap<String, DMNType>(), null, null);
    }

    public CompositeTypeImpl(String namespace, String name, String id) {
        this(namespace, name, id, false, new LinkedHashMap<String, DMNType>(), null, null);
    }

    public CompositeTypeImpl(String namespace, String name, String id, boolean isCollection) {
        this(namespace, name, id, isCollection, new LinkedHashMap<String, DMNType>(), null, null);
    }

    public CompositeTypeImpl(String namespace, String name, String id, boolean isCollection, Map<String, DMNType> fields, DMNType baseType, Type feelType) {
        super(namespace, name, id, isCollection, baseType, feelType);
        this.fields = fields;
        if (feelType == null) {
            feelType = new MapBackedType(name);
            this.setFeelType(feelType);
            if (fields != null) {
                for (Map.Entry<String, DMNType> field : fields.entrySet()) {
                    ((MapBackedType)feelType).addField(field.getKey(), ((BaseDMNTypeImpl)field.getValue()).getFeelType());
                }
            }
        }
    }

    @Override
    public Map<String, DMNType> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void addField(String name, DMNType type) {
        this.fields.put(name, type);
        ((MapBackedType)this.getFeelType()).addField(name, ((BaseDMNTypeImpl)type).getFeelType());
    }

    public String toString(Object value) {
        return null;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public CompositeTypeImpl clone() {
        return new CompositeTypeImpl(this.getNamespace(), this.getName(), this.getId(), this.isCollection(), new LinkedHashMap<String, DMNType>(this.fields), this.getBaseType(), this.getFeelType());
    }

    @Override
    protected boolean internalIsInstanceOf(Object o) {
        if (this.getBaseType() != null) {
            return this.getBaseType().isInstanceOf(o);
        }
        if (o instanceof Map) {
            Map instance = (Map)o;
            for (Map.Entry<String, DMNType> f : this.fields.entrySet()) {
                if (!instance.containsKey(f.getKey())) {
                    return false;
                }
                if (f.getValue().isInstanceOf(instance.get(f.getKey()))) continue;
                return false;
            }
            return true;
        }
        for (Map.Entry<String, DMNType> f : this.fields.entrySet()) {
            Method getter = EvalHelper.getGenericAccessor(o.getClass(), (String)f.getKey());
            if (getter != null) {
                Object invoked;
                try {
                    invoked = getter.invoke(o, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return false;
                }
                Object fieldValue = EvalHelper.coerceNumber((Object)invoked);
                if (f.getValue().isInstanceOf(fieldValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean internalIsAssignableValue(Object o) {
        if (this.getBaseType() != null) {
            return this.getBaseType().isAssignableValue(o);
        }
        if (o instanceof Map) {
            Map instance = (Map)o;
            for (Map.Entry<String, DMNType> f : this.fields.entrySet()) {
                if (!instance.containsKey(f.getKey())) {
                    return false;
                }
                if (f.getValue().isAssignableValue(instance.get(f.getKey()))) continue;
                return false;
            }
            return true;
        }
        if (o == null) {
            return true;
        }
        for (Map.Entry<String, DMNType> f : this.fields.entrySet()) {
            Method getter = EvalHelper.getGenericAccessor(o.getClass(), (String)f.getKey());
            if (getter != null) {
                Object invoked;
                try {
                    invoked = getter.invoke(o, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return false;
                }
                Object fieldValue = EvalHelper.coerceNumber((Object)invoked);
                if (f.getValue().isAssignableValue(fieldValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

