/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.kie.dmn.api.core.DMNContext;

public class DMNContextImpl
implements DMNContext {
    private static final String DEFAULT_IDENT = "    ";
    private Map<String, Object> entries = new LinkedHashMap<String, Object>();
    private Deque<ScopeReference> stack = new LinkedList<ScopeReference>();

    public DMNContextImpl() {
    }

    public DMNContextImpl(Map<String, Object> entries) {
        this.entries.putAll(entries);
    }

    public Object set(String name, Object value) {
        return this.getCurrentEntries().put(name, value);
    }

    public Object get(String name) {
        return this.getCurrentEntries().get(name);
    }

    private Map<String, Object> getCurrentEntries() {
        if (this.stack.isEmpty()) {
            return this.entries;
        }
        return this.stack.peek().getRef();
    }

    public void pushScope(String name, String namespace) {
        Map scopeRef = (Map)this.getCurrentEntries().computeIfAbsent(name, s -> new LinkedHashMap());
        this.stack.push(new ScopeReference(name, namespace, scopeRef));
    }

    public void popScope() {
        this.stack.pop();
    }

    public Optional<String> scopeNamespace() {
        if (this.stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.stack.peek().getNamespace());
    }

    public Map<String, Object> getAll() {
        return this.getCurrentEntries();
    }

    public boolean isDefined(String name) {
        return this.getCurrentEntries().containsKey(name);
    }

    public DMNContext clone() {
        DMNContextImpl newCtx = new DMNContextImpl(new LinkedHashMap<String, Object>(this.entries));
        for (ScopeReference e : this.stack) {
            newCtx.pushScope(e.getName(), e.getNamespace());
        }
        return newCtx;
    }

    public String toString() {
        return this.printContext(this.entries, "");
    }

    private String printContext(Map<String, Object> context, String ident) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (Map.Entry<String, Object> e : context.entrySet()) {
            builder.append(ident).append(DEFAULT_IDENT).append((Object)e.getKey()).append(": ");
            if (e.getValue() instanceof Map) {
                builder.append(this.printContext((Map)e.getValue(), ident + DEFAULT_IDENT));
                continue;
            }
            builder.append(e.getValue()).append("\n");
        }
        builder.append(ident + "}\n");
        return builder.toString();
    }

    public static class ScopeReference {
        private final String name;
        private final String namespace;
        private final Map<String, Object> ref;

        public ScopeReference(String name, String namespace, Map<String, Object> ref) {
            this.name = name;
            this.namespace = namespace;
            this.ref = ref;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, Object> getRef() {
            return this.ref;
        }
    }
}

