/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.jms;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.jbpm.casemgmt.api.audit.CaseFileData;
import org.jbpm.casemgmt.impl.audit.CaseFileDataLog;
import org.jbpm.casemgmt.impl.audit.CaseRoleAssignmentLog;
import org.jbpm.casemgmt.impl.model.AuditCaseInstanceData;
import org.kie.soup.commons.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCaseInstanceAuditEventReceiver
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(AsyncCaseInstanceAuditEventReceiver.class);
    private EntityManagerFactory entityManagerFactory;
    private XStream xstream;

    public AsyncCaseInstanceAuditEventReceiver(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.initXStream();
    }

    private void initXStream() {
        if (this.xstream == null) {
            this.xstream = XStreamUtils.createTrustingXStream();
            String[] voidDeny = new String[]{"void.class", "Void.class"};
            this.xstream.denyTypes(voidDeny);
        }
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            EntityManager em = this.getEntityManager();
            TextMessage textMessage = (TextMessage)message;
            try {
                String messageContent = textMessage.getText();
                Integer eventType = textMessage.getIntProperty("EventType");
                logger.debug("Processing message with event type {} and content {}", (Object)eventType, (Object)messageContent);
                AuditCaseInstanceData event = (AuditCaseInstanceData)this.xstream.fromXML(messageContent);
                switch (eventType) {
                    case 0: {
                        if (event.getCaseRoleAssignments() != null) {
                            for (CaseRoleAssignmentLog roleAssignment : event.getCaseRoleAssignments()) {
                                em.persist((Object)roleAssignment);
                            }
                        }
                        if (event.getCaseFileData() == null) break;
                        for (CaseFileData caseFileData : event.getCaseFileData()) {
                            em.persist((Object)caseFileData);
                        }
                        break;
                    }
                    case 1: {
                        int updated = em.createQuery("update CaseRoleAssignmentLog set processInstanceId =:piID where caseId =:caseId").setParameter("piID", (Object)event.getProcessInstanceId()).setParameter("caseId", (Object)event.getCaseId()).executeUpdate();
                        logger.debug("Updated {} role assignment entries for case id {}", (Object)updated, (Object)event.getCaseId());
                        this.updateCaseFileItems(event, em);
                        break;
                    }
                    case 2: {
                        try {
                            Long processInstanceId = (Long)em.createQuery("select processInstanceId from ProcessInstanceLog where correlationKey =:caseId").setParameter("caseId", (Object)event.getCaseId()).getSingleResult();
                            if (event.getCaseRoleAssignments() == null) break;
                            for (CaseRoleAssignmentLog roleAssignment : event.getCaseRoleAssignments()) {
                                roleAssignment.setProcessInstanceId(processInstanceId);
                                em.persist((Object)roleAssignment);
                            }
                            break;
                        }
                        catch (NoResultException | NonUniqueResultException throwable) {
                            break;
                        }
                    }
                    case 3: {
                        if (event.getCaseRoleAssignments() == null) break;
                        for (CaseRoleAssignmentLog roleAssignment : event.getCaseRoleAssignments()) {
                            em.createQuery("delete from CaseRoleAssignmentLog where caseId =:caseId and roleName =:role and entityId =:entity").setParameter("role", (Object)roleAssignment.getRoleName()).setParameter("entity", (Object)roleAssignment.getEntityId()).setParameter("caseId", (Object)event.getCaseId()).executeUpdate();
                            logger.debug("Removed {} role assignment for entity {} for case id {}", new Object[]{roleAssignment.getRoleName(), roleAssignment.getEntityId(), event.getCaseId()});
                        }
                        break;
                    }
                    case 4: {
                        this.updateCaseFileItems(event, em);
                        break;
                    }
                    case 5: {
                        if (event.getCaseFileData() == null) break;
                        em.createQuery("delete from CaseFileDataLog where caseId =:caseId and itemName in (:itemNames)").setParameter("itemNames", event.getCaseFileData().stream().map(item -> item.getItemName()).collect(Collectors.toList())).setParameter("caseId", (Object)event.getCaseId()).executeUpdate();
                        break;
                    }
                    default: {
                        logger.warn("Unsupported event type {}", (Object)eventType);
                    }
                }
                em.flush();
                em.close();
            }
            catch (JMSException e) {
                throw new RuntimeException("Exception when receiving case instance audit event ", e);
            }
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    protected void updateCaseFileItems(AuditCaseInstanceData auditCaseInstanceData, EntityManager em) {
        if (auditCaseInstanceData.getCaseFileData() == null || auditCaseInstanceData.getCaseFileData().isEmpty()) {
            return;
        }
        List<String> currentCaseData = this.currentCaseData(auditCaseInstanceData.getCaseId(), em);
        auditCaseInstanceData.getCaseFileData().forEach(item -> {
            CaseFileDataLog caseFileDataLog = null;
            if (currentCaseData.contains(item.getItemName())) {
                logger.debug("Case instance {} has already stored log value for {} thus it's going to be updated", (Object)auditCaseInstanceData.getCaseId(), (Object)item.getItemName());
                caseFileDataLog = this.caseFileDataByName(auditCaseInstanceData.getCaseId(), item.getItemName(), em);
                caseFileDataLog.setItemType(item.getItemType());
                caseFileDataLog.setItemValue(item.getItemValue());
                caseFileDataLog.setLastModified(item.getLastModified());
                caseFileDataLog.setLastModifiedBy(item.getLastModifiedBy());
                em.merge((Object)caseFileDataLog);
            } else {
                logger.debug("Case instance {} has no log value for {} thus it's going to be inserted", (Object)auditCaseInstanceData.getCaseId(), (Object)item.getItemName());
                em.persist(item);
            }
        });
    }

    protected List<String> currentCaseData(String caseId, EntityManager em) {
        List caseDataLog = em.createQuery("select itemName from CaseFileDataLog where caseId =:caseId").setParameter("caseId", (Object)caseId).getResultList();
        return caseDataLog;
    }

    protected CaseFileDataLog caseFileDataByName(String caseId, String name, EntityManager em) {
        return (CaseFileDataLog)em.createQuery("select cfdl from CaseFileDataLog cfdl where cfdl.caseId =:caseId and cfdl.itemName =:itemName").setParameter("caseId", (Object)caseId).setParameter("itemName", (Object)name).getSingleResult();
    }
}

