/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.engine.sort.DataSetRowComparator;
import org.dashbuilder.dataset.engine.sort.DataSetSortAlgorithm;
import org.dashbuilder.dataset.sort.ColumnSort;

public class CollectionsDataSetSort
implements DataSetSortAlgorithm {
    @Override
    public List<Integer> sort(DataSet dataSet, List<ColumnSort> columnSortList) {
        return this.sort(dataSet, null, columnSortList);
    }

    @Override
    public List<Integer> sort(DataSet dataSet, List<Integer> rowNumbers, List<ColumnSort> columnSortList) {
        DataSetRowComparator comparator = new DataSetRowComparator();
        for (ColumnSort columnSort : columnSortList) {
            DataColumn column = dataSet.getColumnById(columnSort.getColumnId());
            if (column == null) {
                throw new IllegalArgumentException("Sort column not found: " + columnSort.getColumnId());
            }
            comparator.criteria(column, columnSort.getOrder());
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (rowNumbers != null) {
            rows.addAll(rowNumbers);
        } else {
            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                rows.add(i);
            }
        }
        Collections.sort(rows, comparator);
        return rows;
    }
}

