/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;

public class PeopleAssignmentHelper {
    public static final String ACTOR_ID = "ActorId";
    public static final String GROUP_ID = "GroupId";
    public static final String BUSINESSADMINISTRATOR_ID = "BusinessAdministratorId";
    public static final String BUSINESSADMINISTRATOR_GROUP_ID = "BusinessAdministratorGroupId";
    public static final String TASKSTAKEHOLDER_ID = "TaskStakeholderId";
    public static final String EXCLUDED_OWNER_ID = "ExcludedOwnerId";
    public static final String RECIPIENT_ID = "RecipientId";
    public static final String DEFAULT_ADMIN_USER = System.getProperty("org.jbpm.ht.admin.user", "Administrator");
    public static final String DEFAULT_ADMIN_GROUP = System.getProperty("org.jbpm.ht.admin.group", "Administrators");
    private String separator;
    private CaseData caseFile;
    private String administratorUser = DEFAULT_ADMIN_USER;
    private String administratorGroup = DEFAULT_ADMIN_GROUP;
    private Predicate<? super OrganizationalEntity> userFilter = oe -> oe instanceof User;
    private Predicate<? super OrganizationalEntity> groupFilter = oe -> oe instanceof Group;
    private Predicate<? super OrganizationalEntity> noFilter = oe -> true;

    public PeopleAssignmentHelper() {
        this.separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    }

    public PeopleAssignmentHelper(String separator) {
        this.separator = separator;
    }

    public PeopleAssignmentHelper(String adminUser, String adminGroup) {
        this.administratorUser = adminUser;
        this.administratorGroup = adminGroup;
    }

    public PeopleAssignmentHelper(CaseData caseFile) {
        this();
        this.caseFile = caseFile;
    }

    public void handlePeopleAssignments(WorkItem workItem, InternalTask task, InternalTaskData taskData) {
        InternalPeopleAssignments peopleAssignments = this.getNullSafePeopleAssignments((Task)task);
        this.assignActors(workItem, (PeopleAssignments)peopleAssignments, taskData);
        this.assignGroups(workItem, (PeopleAssignments)peopleAssignments);
        this.assignBusinessAdministrators(workItem, (PeopleAssignments)peopleAssignments);
        this.assignTaskStakeholders(workItem, peopleAssignments);
        this.assignExcludedOwners(workItem, peopleAssignments);
        this.assignRecipients(workItem, peopleAssignments);
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
    }

    protected void assignActors(WorkItem workItem, PeopleAssignments peopleAssignments, InternalTaskData taskData) {
        List potentialOwners = peopleAssignments.getPotentialOwners();
        Object actorIds = this.adjustParam(workItem.getParameter(ACTOR_ID), this.userFilter);
        if (actorIds instanceof Collection) {
            this.processPeopleAssignments((Collection)actorIds, potentialOwners);
        } else {
            this.processPeopleAssignments((String)actorIds, potentialOwners, true);
        }
        if (potentialOwners.size() > 0 && taskData.getCreatedBy() == null) {
            OrganizationalEntity firstPotentialOwner = (OrganizationalEntity)potentialOwners.get(0);
            taskData.setCreatedBy((User)firstPotentialOwner);
        }
    }

    protected void assignGroups(WorkItem workItem, PeopleAssignments peopleAssignments) {
        List potentialOwners = peopleAssignments.getPotentialOwners();
        Object groupIds = this.adjustParam(workItem.getParameter(GROUP_ID), this.groupFilter);
        if (groupIds instanceof Collection) {
            this.processPeopleAssignments((Collection)groupIds, potentialOwners);
        } else {
            this.processPeopleAssignments((String)groupIds, potentialOwners, false);
        }
    }

    protected void assignBusinessAdministrators(WorkItem workItem, PeopleAssignments peopleAssignments) {
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        Object businessAdminGroupIds = this.adjustParam(workItem.getParameter(BUSINESSADMINISTRATOR_GROUP_ID), this.groupFilter);
        Object businessAdministratorIds = this.adjustParam(workItem.getParameter(BUSINESSADMINISTRATOR_ID), this.userFilter);
        if (!this.hasAdminAssigned(businessAdministrators)) {
            User administrator = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)administrator).setId(this.administratorUser);
            businessAdministrators.add(administrator);
            Group adminGroup = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)adminGroup).setId(this.administratorGroup);
            businessAdministrators.add(adminGroup);
        }
        if (businessAdministratorIds instanceof Collection) {
            this.processPeopleAssignments((Collection)businessAdministratorIds, businessAdministrators);
        } else {
            this.processPeopleAssignments((String)businessAdministratorIds, businessAdministrators, true);
        }
        if (businessAdminGroupIds instanceof Collection) {
            this.processPeopleAssignments((Collection)businessAdminGroupIds, businessAdministrators);
        } else {
            this.processPeopleAssignments((String)businessAdminGroupIds, businessAdministrators, false);
        }
    }

    protected void assignTaskStakeholders(WorkItem workItem, InternalPeopleAssignments peopleAssignments) {
        List taskStakeholders = peopleAssignments.getTaskStakeholders();
        Object taskStakehodlerIds = this.adjustParam(workItem.getParameter(TASKSTAKEHOLDER_ID), this.noFilter);
        if (taskStakehodlerIds instanceof Collection) {
            this.processPeopleAssignments((Collection)taskStakehodlerIds, taskStakeholders);
        } else {
            this.processPeopleAssignments((String)taskStakehodlerIds, taskStakeholders, true);
        }
    }

    protected void assignExcludedOwners(WorkItem workItem, InternalPeopleAssignments peopleAssignments) {
        List excludedOwners = peopleAssignments.getExcludedOwners();
        Object excludedOwnerIds = this.adjustParam(workItem.getParameter(EXCLUDED_OWNER_ID), this.userFilter);
        if (excludedOwnerIds instanceof Collection) {
            this.processPeopleAssignments((Collection)excludedOwnerIds, excludedOwners);
        } else {
            this.processPeopleAssignments((String)excludedOwnerIds, excludedOwners, true);
        }
    }

    protected void assignRecipients(WorkItem workItem, InternalPeopleAssignments peopleAssignments) {
        List recipients = peopleAssignments.getRecipients();
        Object recipientIds = this.adjustParam(workItem.getParameter(RECIPIENT_ID), this.noFilter);
        if (recipientIds instanceof Collection) {
            this.processPeopleAssignments((Collection)recipientIds, recipients);
        } else {
            this.processPeopleAssignments((String)recipientIds, recipients, true);
        }
    }

    protected void processPeopleAssignments(String peopleAssignmentIds, List<OrganizationalEntity> organizationalEntities, boolean user) {
        if (peopleAssignmentIds != null && peopleAssignmentIds.trim().length() > 0) {
            String[] ids;
            for (String id : ids = peopleAssignmentIds.split(this.separator)) {
                if ((id = id.trim()).length() == 0) continue;
                boolean exists = false;
                for (OrganizationalEntity orgEntity : organizationalEntities) {
                    if (!orgEntity.getId().equals(id)) continue;
                    exists = true;
                }
                if (exists) continue;
                User organizationalEntity = null;
                if (user) {
                    organizationalEntity = TaskModelProvider.getFactory().newUser();
                    ((InternalOrganizationalEntity)organizationalEntity).setId(id);
                } else {
                    organizationalEntity = TaskModelProvider.getFactory().newGroup();
                    ((InternalOrganizationalEntity)organizationalEntity).setId(id);
                }
                organizationalEntities.add((OrganizationalEntity)organizationalEntity);
            }
        }
    }

    protected void processPeopleAssignments(Collection<OrganizationalEntity> peopleAssignmentIds, List<OrganizationalEntity> organizationalEntities) {
        if (peopleAssignmentIds != null) {
            for (OrganizationalEntity entity : peopleAssignmentIds) {
                boolean exists = organizationalEntities.contains(entity);
                if (exists) continue;
                organizationalEntities.add(entity);
            }
        }
    }

    protected InternalPeopleAssignments getNullSafePeopleAssignments(Task task) {
        InternalPeopleAssignments peopleAssignments = (InternalPeopleAssignments)task.getPeopleAssignments();
        if (peopleAssignments == null) {
            peopleAssignments = (InternalPeopleAssignments)TaskModelProvider.getFactory().newPeopleAssignments();
            peopleAssignments.setPotentialOwners(new ArrayList());
            peopleAssignments.setBusinessAdministrators(new ArrayList());
            peopleAssignments.setExcludedOwners(new ArrayList());
            peopleAssignments.setRecipients(new ArrayList());
            peopleAssignments.setTaskStakeholders(new ArrayList());
        }
        return peopleAssignments;
    }

    protected boolean hasAdminAssigned(Collection<OrganizationalEntity> businessAdmins) {
        for (OrganizationalEntity entity : businessAdmins) {
            if (!this.administratorUser.equals(entity.getId()) && !this.administratorGroup.equals(entity.getId())) continue;
            return true;
        }
        return false;
    }

    protected Object adjustParam(Object currentValue, Predicate<? super OrganizationalEntity> filter) {
        if (currentValue == null || this.caseFile == null) {
            return currentValue;
        }
        try {
            if (this.caseFile instanceof CaseAssignment) {
                String[] ids;
                ArrayList foundMatchingAssignment = new ArrayList();
                for (String id : ids = currentValue.toString().split(this.separator)) {
                    Collection tmp = ((CaseAssignment)this.caseFile).getAssignments(id).stream().filter(filter).collect(Collectors.toList());
                    if (tmp.isEmpty()) {
                        throw new RuntimeException("Case role '" + id + "' has no matching assignments");
                    }
                    foundMatchingAssignment.addAll(tmp);
                }
                return foundMatchingAssignment;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return currentValue;
    }
}

