/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.dialect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Condition;
import org.dashbuilder.dataprovider.sql.model.CoreCondition;
import org.dashbuilder.dataprovider.sql.model.CreateTable;
import org.dashbuilder.dataprovider.sql.model.Delete;
import org.dashbuilder.dataprovider.sql.model.DynamicDateColumn;
import org.dashbuilder.dataprovider.sql.model.FixedDateColumn;
import org.dashbuilder.dataprovider.sql.model.FunctionColumn;
import org.dashbuilder.dataprovider.sql.model.Insert;
import org.dashbuilder.dataprovider.sql.model.LogicalCondition;
import org.dashbuilder.dataprovider.sql.model.SQLStatement;
import org.dashbuilder.dataprovider.sql.model.Select;
import org.dashbuilder.dataprovider.sql.model.SimpleColumn;
import org.dashbuilder.dataprovider.sql.model.SortColumn;
import org.dashbuilder.dataprovider.sql.model.Table;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.sort.SortOrder;

public class DefaultDialect
implements Dialect {
    private static final String AND = " AND ";
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");

    @Override
    public String[] getExcludedColumns() {
        return new String[0];
    }

    @Override
    public String getColumnSQL(Column column) {
        if (column instanceof FunctionColumn) {
            return this.getFunctionColumnSQL((FunctionColumn)column);
        }
        if (column instanceof SortColumn) {
            return this.getSortColumnSQL((SortColumn)column);
        }
        if (column instanceof DynamicDateColumn) {
            return this.getDynamicDateColumnSQL((DynamicDateColumn)column);
        }
        if (column instanceof FixedDateColumn) {
            return this.getFixedDateColumnSQL((FixedDateColumn)column);
        }
        if (column instanceof SimpleColumn) {
            return this.getSimpleColumnSQL((SimpleColumn)column);
        }
        return this.getColumnNameSQL(column.getName());
    }

    @Override
    public String getColumnTypeSQL(Column column) {
        switch (column.getType()) {
            case NUMBER: {
                return "NUMERIC(28,2)";
            }
            case DATE: {
                return "TIMESTAMP";
            }
        }
        return "VARCHAR(" + column.getLength() + ")";
    }

    @Override
    public String convertToString(Object value) {
        try {
            return value == null ? null : (String)value;
        }
        catch (ClassCastException e) {
            return value.toString();
        }
    }

    @Override
    public Double convertToDouble(Object value) {
        try {
            return value == null ? null : Double.valueOf(((Number)value).doubleValue());
        }
        catch (ClassCastException e) {
            return Double.parseDouble(value.toString());
        }
    }

    @Override
    public Date convertToDate(Object value) {
        try {
            return value == null ? null : (Date)value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a java.util.Date: " + value + " (" + value.getClass().getName() + ")");
        }
    }

    @Override
    public String getTableSQL(SQLStatement<?> stmt) {
        Table table = stmt.getTable();
        String name = this.getTableNameSQL(table.getName());
        if (StringUtils.isBlank((CharSequence)table.getSchema())) {
            return name;
        }
        return this.getSchemaNameSQL(table.getSchema()) + "." + name;
    }

    @Override
    public String getTableNameSQL(String name) {
        return name;
    }

    @Override
    public String getSchemaNameSQL(String name) {
        return name;
    }

    @Override
    public String getSimpleColumnSQL(SimpleColumn column) {
        String result = this.getColumnNameSQL(column.getName());
        if (column.getFunctionType() != null) {
            result = this.getColumnFunctionSQL(result, column.getFunctionType());
        }
        return result;
    }

    @Override
    public String getFunctionColumnSQL(FunctionColumn column) {
        if ("lower".equals(column.getFunction())) {
            return this.getLowerFunctionSQL(column.getColumns()[0]);
        }
        if ("concat".equals(column.getFunction())) {
            return this.getConcatFunctionSQL(column.getColumns());
        }
        if ("year".equals(column.getFunction())) {
            return this.getDatePartFunctionSQL("YEAR", column.getColumns()[0]);
        }
        if ("month".equals(column.getFunction())) {
            return this.getDatePartFunctionSQL("MONTH", column.getColumns()[0]);
        }
        if ("day".equals(column.getFunction())) {
            return this.getDatePartFunctionSQL("DAY", column.getColumns()[0]);
        }
        if ("hour".equals(column.getFunction())) {
            return this.getDatePartFunctionSQL("HOUR", column.getColumns()[0]);
        }
        if ("minute".equals(column.getFunction())) {
            return this.getDatePartFunctionSQL("MINUTE", column.getColumns()[0]);
        }
        if ("second".equals(column.getFunction())) {
            return this.getDatePartFunctionSQL("SECOND", column.getColumns()[0]);
        }
        throw new IllegalArgumentException("Column function not supported: " + column.getFunction());
    }

    @Override
    public String getLowerFunctionSQL(Column column) {
        String columnSQL = this.getColumnSQL(column);
        return "LOWER(" + columnSQL + ")";
    }

    @Override
    public String getConcatFunctionSQL(Column[] columns) {
        return this.getConcatFunctionSQL(columns, "(", ")", " || ");
    }

    public String getConcatFunctionSQL(Column[] columns, String begin, String end, String separator) {
        StringBuilder out = new StringBuilder();
        out.append(begin);
        for (int i = 0; i < columns.length; ++i) {
            Column column;
            ColumnType type;
            if (i > 0) {
                out.append(separator);
            }
            if (ColumnType.LABEL.equals((Object)(type = (column = columns[i]).getType())) || ColumnType.TEXT.equals((Object)type)) {
                out.append("'").append(column.getName()).append("'");
                continue;
            }
            out.append(this.getColumnCastSQL(column));
        }
        out.append(end);
        return out.toString();
    }

    public String getColumnCastSQL(Column column) {
        String columnSQL = this.getColumnSQL(column);
        return "CAST(" + columnSQL + " AS VARCHAR)";
    }

    @Override
    public String getDatePartFunctionSQL(String part, Column column) {
        String columnSQL = this.getColumnSQL(column);
        return "EXTRACT(" + part + " FROM " + columnSQL + ")";
    }

    @Override
    public String getSortColumnSQL(SortColumn sortColumn) {
        Column column = sortColumn.getSource();
        String columnSQL = this.getColumnSQL(column);
        if (!StringUtils.isBlank((CharSequence)column.getAlias())) {
            columnSQL = this.getAliasForStatementSQL(column.getAlias());
        }
        return columnSQL + " " + this.getSortOrderSQL(sortColumn.getOrder());
    }

    @Override
    public String getSortOrderSQL(SortOrder order) {
        if (SortOrder.ASCENDING.equals((Object)order)) {
            return "ASC";
        }
        if (SortOrder.DESCENDING.equals((Object)order)) {
            return "DESC";
        }
        throw new IllegalArgumentException("Sort order not supported: " + order);
    }

    @Override
    public String getDynamicDateColumnSQL(DynamicDateColumn column) {
        Column dateColumn = this.toChar(column);
        return this.getColumnSQL(dateColumn);
    }

    public Column toChar(DynamicDateColumn column) {
        Column target = SQLFactory.column(column.getName());
        DateIntervalType type = column.getDateType();
        Column SEPARATOR_DATE = SQLFactory.column("-", ColumnType.TEXT, 3);
        Column SEPARATOR_EMPTY = SQLFactory.column(" ", ColumnType.TEXT, 3);
        Column SEPARATOR_TIME = SQLFactory.column(":", ColumnType.TEXT, 3);
        if (DateIntervalType.SECOND.equals((Object)type)) {
            return SQLFactory.concat(target.year(), SEPARATOR_DATE, target.month(), SEPARATOR_DATE, target.day(), SEPARATOR_EMPTY, target.hour(), SEPARATOR_TIME, target.minute(), SEPARATOR_TIME, target.second());
        }
        if (DateIntervalType.MINUTE.equals((Object)type)) {
            return SQLFactory.concat(target.year(), SEPARATOR_DATE, target.month(), SEPARATOR_DATE, target.day(), SEPARATOR_EMPTY, target.hour(), SEPARATOR_TIME, target.minute());
        }
        if (DateIntervalType.HOUR.equals((Object)type)) {
            return SQLFactory.concat(target.year(), SEPARATOR_DATE, target.month(), SEPARATOR_DATE, target.day(), SEPARATOR_EMPTY, target.hour());
        }
        if (DateIntervalType.DAY.equals((Object)type) || DateIntervalType.WEEK.equals((Object)type)) {
            return SQLFactory.concat(target.year(), SEPARATOR_DATE, target.month(), SEPARATOR_DATE, target.day());
        }
        if (DateIntervalType.MONTH.equals((Object)type) || DateIntervalType.QUARTER.equals((Object)type)) {
            return SQLFactory.concat(target.year(), SEPARATOR_DATE, target.month());
        }
        if (DateIntervalType.YEAR.equals((Object)type) || DateIntervalType.DECADE.equals((Object)type) || DateIntervalType.CENTURY.equals((Object)type) || DateIntervalType.MILLENIUM.equals((Object)type)) {
            return target.year();
        }
        throw new IllegalArgumentException("Group '" + target.getName() + "' by the given date interval type is not supported: " + type);
    }

    @Override
    public String getFixedDateColumnSQL(FixedDateColumn column) {
        Column target = SQLFactory.column(column.getName());
        DateIntervalType type = column.getDateType();
        if (DateIntervalType.SECOND.equals((Object)type)) {
            return this.getColumnSQL(target.second());
        }
        if (DateIntervalType.MINUTE.equals((Object)type)) {
            return this.getColumnSQL(target.minute());
        }
        if (DateIntervalType.HOUR.equals((Object)type)) {
            return this.getColumnSQL(target.hour());
        }
        if (DateIntervalType.DAY_OF_WEEK.equals((Object)type)) {
            return this.getColumnSQL(target.day());
        }
        if (DateIntervalType.MONTH.equals((Object)type)) {
            return this.getColumnSQL(target.month());
        }
        if (DateIntervalType.QUARTER.equals((Object)type)) {
            return this.getColumnSQL(target.month());
        }
        throw new IllegalArgumentException("Interval size '" + type + "' not supported for fixed date intervals. The only supported sizes are: " + StringUtils.join((Iterable)DateIntervalType.FIXED_INTERVALS_SUPPORTED, (String)","));
    }

    @Override
    public String getColumnNameSQL(String name) {
        return name;
    }

    @Override
    public String getColumnNameQuotedSQL(String name) {
        return "\"" + name + "\"";
    }

    @Override
    public String getAliasForColumnSQL(String alias) {
        return "\"" + alias + "\"";
    }

    @Override
    public String getAliasForStatementSQL(String alias) {
        return "\"" + alias + "\"";
    }

    @Override
    public String getConditionSQL(Condition condition) {
        if (condition instanceof CoreCondition) {
            return this.getCoreConditionSQL((CoreCondition)condition);
        }
        if (condition instanceof LogicalCondition) {
            return this.getLogicalConditionSQL((LogicalCondition)condition);
        }
        throw new IllegalArgumentException("Condition type not supported: " + condition);
    }

    @Override
    public String getCoreConditionSQL(CoreCondition condition) {
        String columnSQL = this.getColumnSQL(condition.getColumn());
        CoreFunctionType type = condition.getFunction();
        Object[] params = condition.getParameters();
        if (CoreFunctionType.IS_NULL.equals((Object)type)) {
            return this.getIsNullConditionSQL(columnSQL);
        }
        if (CoreFunctionType.NOT_NULL.equals((Object)type)) {
            return this.getNotNullConditionSQL(columnSQL);
        }
        if (CoreFunctionType.EQUALS_TO.equals((Object)type)) {
            return this.getIsEqualsToConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type)) {
            return this.getNotEqualsToConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type)) {
            return this.getNotEqualsToConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.LIKE_TO.equals((Object)type)) {
            return this.getLikeToConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.GREATER_THAN.equals((Object)type)) {
            return this.getGreaterThanConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)type)) {
            return this.getGreaterOrEqualsConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.LOWER_THAN.equals((Object)type)) {
            return this.getLowerThanConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)type)) {
            return this.getLowerOrEqualsConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.BETWEEN.equals((Object)type)) {
            return this.getBetweenConditionSQL(columnSQL, params[0], params[1]);
        }
        if (CoreFunctionType.IN.equals((Object)type)) {
            return this.getInConditionSQL(columnSQL, params[0]);
        }
        if (CoreFunctionType.NOT_IN.equals((Object)type)) {
            return this.getNotInConditionSQL(columnSQL, params[0]);
        }
        throw new IllegalArgumentException("Core condition type not supported: " + type);
    }

    @Override
    public String getNotNullConditionSQL(String column) {
        return column + " IS NOT NULL";
    }

    @Override
    public String getIsNullConditionSQL(String column) {
        return column + " IS NULL";
    }

    @Override
    public String getIsEqualsToConditionSQL(String column, Object param) {
        if (param == null) {
            return this.getIsNullConditionSQL(column);
        }
        String paramStr = this.getParameterSQL(param);
        return column + " = " + paramStr;
    }

    @Override
    public String getNotEqualsToConditionSQL(String column, Object param) {
        if (param == null) {
            return this.getNotNullConditionSQL(column);
        }
        String paramStr = this.getParameterSQL(param);
        return column + " <> " + paramStr;
    }

    @Override
    public String getLikeToConditionSQL(String column, Object param) {
        String paramStr = this.getParameterSQL(param);
        return column + " LIKE " + paramStr;
    }

    @Override
    public String getGreaterThanConditionSQL(String column, Object param) {
        String paramStr = this.getParameterSQL(param);
        return column + " > " + paramStr;
    }

    @Override
    public String getGreaterOrEqualsConditionSQL(String column, Object param) {
        String paramStr = this.getParameterSQL(param);
        return column + " >= " + paramStr;
    }

    @Override
    public String getLowerThanConditionSQL(String column, Object param) {
        String paramStr = this.getParameterSQL(param);
        return column + " < " + paramStr;
    }

    @Override
    public String getLowerOrEqualsConditionSQL(String column, Object param) {
        String paramStr = this.getParameterSQL(param);
        return column + " <= " + paramStr;
    }

    @Override
    public String getBetweenConditionSQL(String column, Object from, Object to) {
        String fromStr = this.getParameterSQL(from);
        String toStr = this.getParameterSQL(to);
        return column + " BETWEEN " + fromStr + AND + toStr;
    }

    @Override
    public String getInConditionSQL(String column, Object param) {
        StringBuilder inStatement = new StringBuilder();
        inStatement.append(column);
        inStatement.append(" IN (");
        for (Object p : (Collection)param) {
            inStatement.append(this.getParameterSQL(p) + ",");
        }
        inStatement.deleteCharAt(inStatement.length() - 1);
        inStatement.append(")");
        return inStatement.toString();
    }

    @Override
    public String getNotInConditionSQL(String column, Object param) {
        StringBuilder inStatement = new StringBuilder();
        inStatement.append(column);
        inStatement.append(" NOT IN (");
        for (Object p : (Collection)param) {
            inStatement.append(this.getParameterSQL(p) + ",");
        }
        inStatement.deleteCharAt(inStatement.length() - 1);
        inStatement.append(")");
        return inStatement.toString();
    }

    @Override
    public String getParameterSQL(Object param) {
        if (param == null) {
            return "null";
        }
        if (param instanceof Number) {
            return this.getNumberParameterSQL((Number)param);
        }
        if (param instanceof Date) {
            return this.getDateParameterSQL((Date)param);
        }
        return this.getStringParameterSQL(param.toString());
    }

    @Override
    public String getNumberParameterSQL(Number param) {
        return param.toString();
    }

    @Override
    public String getDateParameterSQL(Date param) {
        return "TIMESTAMP '" + this.dateFormat.format(param) + "'";
    }

    @Override
    public String getStringParameterSQL(String param) {
        String escapedParam = param.replaceAll("'", "''");
        return "'" + escapedParam + "'";
    }

    @Override
    public String getLogicalConditionSQL(LogicalCondition condition) {
        LogicalExprType type = condition.getType();
        Condition[] conditions = condition.getConditions();
        if (LogicalExprType.NOT.equals((Object)type)) {
            return this.getNotExprConditionSQL(conditions[0]);
        }
        if (LogicalExprType.AND.equals((Object)type)) {
            return this.getAndExprConditionSQL(conditions);
        }
        if (LogicalExprType.OR.equals((Object)type)) {
            return this.getOrExprConditionSQL(conditions);
        }
        throw new IllegalArgumentException("Logical condition type not supported: " + type);
    }

    @Override
    public String getNotExprConditionSQL(Condition condition) {
        String conditionSQL = this.getConditionSQL(condition);
        return "NOT(" + conditionSQL + ")";
    }

    @Override
    public String getAndExprConditionSQL(Condition[] conditions) {
        return this._getLogicalExprConditionSQL(conditions, "AND");
    }

    @Override
    public String getOrExprConditionSQL(Condition[] conditions) {
        return this._getLogicalExprConditionSQL(conditions, "OR");
    }

    protected String _getLogicalExprConditionSQL(Condition[] conditions, String op) {
        StringBuilder out = new StringBuilder();
        out.append("(");
        for (int i = 0; i < conditions.length; ++i) {
            Condition condition = conditions[i];
            String conditionSQL = this.getConditionSQL(condition);
            if (i > 0) {
                out.append(" ").append(op).append(" ");
            }
            out.append(conditionSQL);
        }
        out.append(")");
        return out.toString();
    }

    @Override
    public String getColumnFunctionSQL(String column, AggregateFunctionType function) {
        switch (function) {
            case SUM: {
                return "SUM(" + column + ")";
            }
            case MAX: {
                return "MAX(" + column + ")";
            }
            case MIN: {
                return "MIN(" + column + ")";
            }
            case AVERAGE: {
                return "AVG(" + column + ")";
            }
            case COUNT: {
                return "COUNT(" + column + ")";
            }
            case DISTINCT: {
                return "COUNT(DISTINCT " + column + ")";
            }
        }
        throw new IllegalArgumentException("Function type not valid: " + function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCountQuerySQL(Select select) {
        ArrayList<SortColumn> sortColumns = new ArrayList<SortColumn>();
        sortColumns.addAll(select.getOrderBys());
        try {
            select.getOrderBys().clear();
            String string = "SELECT " + this.getColumnFunctionSQL("*", AggregateFunctionType.COUNT) + " FROM (" + select.getSQL() + ") " + this.getAliasForColumnSQL("dbSQL");
            return string;
        }
        finally {
            select.orderBy(sortColumns);
        }
    }

    @Override
    public String getSQL(CreateTable create) {
        StringBuilder sql = new StringBuilder("CREATE TABLE ");
        ArrayList<String> pkeys = new ArrayList<String>();
        String tname = this.getTableSQL(create);
        sql.append(tname);
        boolean first = true;
        sql.append(" (\n");
        for (Column column : create.getColumns()) {
            if (!first) {
                sql.append(",\n");
            }
            String name = this.getColumnNameSQL(column.getName());
            String type = this.getColumnTypeSQL(column);
            sql.append(" ").append(name).append(" ").append(type);
            if (create.getPrimaryKeys().contains(column)) {
                sql.append(" NOT NULL");
                pkeys.add(name);
            }
            first = false;
        }
        if (!create.getPrimaryKeys().isEmpty()) {
            sql.append(",\n");
            sql.append(" PRIMARY KEY(");
            sql.append(StringUtils.join(pkeys, (String)","));
            sql.append(")\n");
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public String getSQL(Select select) {
        String limitSql;
        List<SortColumn> orderBys;
        List<Column> groupBys;
        StringBuilder sql = new StringBuilder();
        String selectClause = this.getSelectSQL(select);
        sql.append(selectClause);
        sql.append(" ").append(this.getFromSQL(select));
        List<Condition> wheres = select.getWheres();
        if (!wheres.isEmpty()) {
            sql.append(" ").append(this.getWhereSQL(select));
        }
        if (!(groupBys = select.getGroupBys()).isEmpty()) {
            sql.append(" ").append(this.getGroupBySQL(select));
        }
        if (!(orderBys = select.getOrderBys()).isEmpty()) {
            sql.append(" ").append(this.getOrderBySQL(select));
        }
        int limit = select.getLimit();
        int offset = select.getOffset();
        if (!(limit <= 0 && offset <= 0 || StringUtils.isBlank((CharSequence)(limitSql = this.getOffsetLimitSQL(select))))) {
            sql.append(limitSql);
        }
        return sql.toString();
    }

    @Override
    public String getSQL(Insert insert) {
        String str;
        StringBuilder sql = new StringBuilder();
        String insertClause = this.getInsertStatement(insert);
        sql.append(insertClause);
        sql.append(" ").append(this.getTableSQL(insert));
        boolean first = true;
        sql.append(" (");
        for (Column column : insert.getColumns()) {
            if (!first) {
                sql.append(",");
            }
            str = this.getColumnSQL(column);
            sql.append(str);
            first = false;
        }
        sql.append(")");
        first = true;
        sql.append(" VALUES (");
        for (Column value : insert.getValues()) {
            if (!first) {
                sql.append(",");
            }
            str = this.getParameterSQL(value);
            sql.append(str);
            first = false;
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public String getSQL(Delete delete) {
        StringBuilder sql = new StringBuilder();
        String deleteClause = this.getDeleteStatement(delete);
        sql.append(deleteClause);
        sql.append(" ").append(this.getTableSQL(delete));
        List<Condition> wheres = delete.getWheres();
        if (!wheres.isEmpty()) {
            sql.append(" ").append(this.getWhereSQL(delete));
        }
        return sql.toString();
    }

    @Override
    public String getSelectSQL(Select select) {
        StringBuilder clause = new StringBuilder();
        clause.append(this.getSelectStatement(select));
        clause.append(" ");
        if (select.getColumns().isEmpty()) {
            clause.append("*");
        } else {
            boolean first = true;
            for (Column column : select.getColumns()) {
                boolean isSimpleColumn;
                if (!first) {
                    clause.append(", ");
                }
                String str = this.getColumnSQL(column);
                boolean aliasNonEmpty = !StringUtils.isBlank((CharSequence)column.getAlias());
                boolean bl = isSimpleColumn = column instanceof SimpleColumn && !str.equals(this.getColumnNameSQL(column.getAlias()));
                if (aliasNonEmpty && (this.allowAliasInStatements() || isSimpleColumn)) {
                    str = str + " " + this.getAliasForColumnSQL(column.getAlias());
                }
                clause.append(str);
                first = false;
            }
        }
        return clause.toString();
    }

    @Override
    public String getFromSQL(Select select) {
        String fromSelect = select.getFromSelect();
        Table fromTable = select.getFromTable();
        String from = this.getFromStatement(select);
        if (fromSelect != null) {
            String alias = this.getAliasForColumnSQL("dbSQL");
            return from + " (" + fromSelect + ") " + alias;
        }
        if (fromTable != null) {
            String table = this.getTableSQL(select);
            return from + " " + table;
        }
        return "";
    }

    @Override
    public String getWhereSQL(Select select) {
        StringBuilder sql = new StringBuilder();
        List<Condition> wheres = select.getWheres();
        boolean first = true;
        for (Condition condition : wheres) {
            if (first) {
                sql.append(this.getWhereStatement(select)).append(" ");
            } else {
                sql.append(AND);
            }
            String str = this.getConditionSQL(condition);
            sql.append(str);
            first = false;
        }
        return sql.toString();
    }

    @Override
    public String getWhereSQL(Delete delete) {
        StringBuilder sql = new StringBuilder();
        List<Condition> wheres = delete.getWheres();
        boolean first = true;
        for (Condition condition : wheres) {
            if (first) {
                sql.append(this.getWhereStatement(delete)).append(" ");
            } else {
                sql.append(AND);
            }
            String str = this.getConditionSQL(condition);
            sql.append(str);
            first = false;
        }
        return sql.toString();
    }

    @Override
    public String getGroupBySQL(Select select) {
        StringBuilder sql = new StringBuilder();
        List<Column> groupBys = select.getGroupBys();
        boolean first = true;
        for (Column column : groupBys) {
            if (first) {
                sql.append(this.getGroupByStatement(select)).append(" ");
            } else {
                sql.append(", ");
            }
            Column aliasColumn = this.allowAliasInStatements() ? this.getAliasStatement(select, column) : null;
            sql.append(aliasColumn != null ? this.getAliasForStatementSQL(aliasColumn.getAlias()) : this.getColumnSQL(column));
            first = false;
        }
        return sql.toString();
    }

    @Override
    public String getOrderBySQL(Select select) {
        StringBuilder sql = new StringBuilder();
        List<SortColumn> orderBys = select.getOrderBys();
        boolean first = true;
        for (SortColumn column : orderBys) {
            Column aliasColumn;
            if (first) {
                sql.append(this.getOrderByStatement(select)).append(" ");
            } else {
                sql.append(", ");
            }
            Column column2 = aliasColumn = this.allowAliasInStatements() ? this.getAliasStatement(select, column.getSource()) : null;
            if (aliasColumn != null) {
                column = new SortColumn(aliasColumn, column.getOrder());
            }
            String str = this.getSortColumnSQL(column);
            sql.append(str);
            first = false;
        }
        return sql.toString();
    }

    @Override
    public String getOffsetLimitSQL(Select select) {
        int offset = select.getOffset();
        int limit = select.getLimit();
        StringBuilder out = new StringBuilder();
        if (limit > 0) {
            out.append(" LIMIT ").append(limit);
        }
        if (offset > 0) {
            out.append(" OFFSET ").append(offset);
        }
        return out.toString();
    }

    @Override
    public String getSelectStatement(Select select) {
        return "SELECT";
    }

    @Override
    public String getInsertStatement(Insert insert) {
        return "INSERT INTO";
    }

    @Override
    public String getDeleteStatement(Delete delete) {
        return "DELETE FROM";
    }

    @Override
    public String getFromStatement(Select select) {
        return "FROM";
    }

    @Override
    public String getWhereStatement(Select select) {
        return "WHERE";
    }

    @Override
    public String getWhereStatement(Delete delete) {
        return "WHERE";
    }

    @Override
    public String getGroupByStatement(Select select) {
        return "GROUP BY";
    }

    @Override
    public String getOrderByStatement(Select select) {
        return "ORDER BY";
    }

    protected Object invokeMethod(Object o, String methodName, Object[] params) {
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            try {
                methods[i].setAccessible(true);
                return methods[i].invoke(o, params);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (InvocationTargetException ite) {
                return null;
            }
        }
        return null;
    }

    public boolean areEquals(Column column1, Column column2) {
        if (!column1.getName().equals(column2.getName())) {
            return false;
        }
        if (!column1.getClass().getName().equals(column2.getClass().getName())) {
            return false;
        }
        if (column1 instanceof DynamicDateColumn) {
            DynamicDateColumn dd1 = (DynamicDateColumn)column1;
            DynamicDateColumn dd2 = (DynamicDateColumn)column2;
            if (!dd1.getDateType().equals((Object)dd2.getDateType())) {
                return false;
            }
        }
        if (column1 instanceof FixedDateColumn) {
            FixedDateColumn fd1 = (FixedDateColumn)column1;
            FixedDateColumn fd2 = (FixedDateColumn)column2;
            if (!fd1.getDateType().equals((Object)fd2.getDateType())) {
                return false;
            }
        }
        return true;
    }

    public boolean allowAliasInStatements() {
        return false;
    }

    public Column getAliasStatement(Select select, Column target) {
        for (Column column : select.getColumns()) {
            if (column instanceof SimpleColumn || StringUtils.isBlank((CharSequence)column.getAlias()) || !this.areEquals(column, target)) continue;
            return column;
        }
        return null;
    }
}

