/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import java.util.Optional;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.OOPathExprGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternConstraintParseResult;

class ConstraintOOPath
implements DSLNode {
    private final RuleContext context;
    private final PackageModel packageModel;
    private final PatternDescr pattern;
    private final Class<?> patternType;
    private final PatternConstraintParseResult patternConstraintParseResult;
    private final String expression;
    private final DrlxParseSuccess drlxParseResult;

    public ConstraintOOPath(RuleContext context, PackageModel packageModel, PatternDescr pattern, Class<?> patternType, PatternConstraintParseResult patternConstraintParseResult, String expression, DrlxParseSuccess drlxParseResult) {
        this.context = context;
        this.packageModel = packageModel;
        this.pattern = pattern;
        this.patternType = patternType;
        this.patternConstraintParseResult = patternConstraintParseResult;
        this.expression = expression;
        this.drlxParseResult = drlxParseResult;
    }

    @Override
    public void buildPattern() {
        String patternIdentifierGenerated;
        if (this.patternConstraintParseResult.getPatternIdentifier() != null) {
            patternIdentifierGenerated = this.patternConstraintParseResult.getPatternIdentifier();
        } else {
            patternIdentifierGenerated = this.context.getExprId(this.patternType, this.expression);
            this.context.addDeclaration(patternIdentifierGenerated, this.patternType, Optional.of(this.pattern), Optional.empty());
        }
        new OOPathExprGenerator(this.context, this.packageModel).visit(this.patternType, patternIdentifierGenerated, this.drlxParseResult);
    }
}

