/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.compiler.rule.builder.dialect.mvel.MVELExprAnalyzer;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELObjectExpression;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.KnowledgeHelper;
import org.kie.api.definition.rule.Rule;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.util.PropertyTools;

public class MvelUtil {
    public static MVELObjectExpression createMvelObjectExpression(String expression, ClassLoader classLoader, Map<String, Declaration> decls) {
        if (expression == null) {
            return null;
        }
        ParserConfiguration conf = new ParserConfiguration();
        conf.setClassLoader(classLoader);
        MVELAnalysisResult analysis = MvelUtil.analyzeExpression(expression, conf, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses(decls), null));
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        int i = usedIdentifiers.getDeclrClasses().keySet().size();
        Declaration[] previousDeclarations = new Declaration[i];
        i = 0;
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            previousDeclarations[i++] = decls.get(id);
        }
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        MVELCompilationUnit unit = MVELDialect.getMVELCompilationUnit((String)expression, (AnalysisResult)analysis, (Declaration[])previousDeclarations, null, null, null, (String)"drools", KnowledgeHelper.class, (boolean)false, (MVELCompilationUnit.Scope)MVELCompilationUnit.Scope.EXPRESSION);
        MVELObjectExpression expr = new MVELObjectExpression(unit, "mvel");
        expr.compile(conf);
        return expr;
    }

    public static MVELAnalysisResult analyzeExpression(Class<?> thisClass, String expr) {
        ParserConfiguration conf = new ParserConfiguration();
        conf.setClassLoader(thisClass.getClassLoader());
        return MvelUtil.analyzeExpression(expr, conf, new BoundIdentifiers(thisClass));
    }

    private static MVELAnalysisResult analyzeExpression(String expr, ParserConfiguration conf, BoundIdentifiers availableIdentifiers) {
        Class returnType;
        if (expr.trim().length() <= 0) {
            MVELAnalysisResult result = MVELExprAnalyzer.analyze((Set)Collections.EMPTY_SET, (BoundIdentifiers)availableIdentifiers);
            result.setMvelVariables(new HashMap());
            result.setTypesafe(true);
            return result;
        }
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        ParserContext parserContext1 = new ParserContext(conf);
        if (availableIdentifiers.getThisClass() != null) {
            parserContext1.addInput("this", availableIdentifiers.getThisClass());
        }
        if (availableIdentifiers.getOperators() != null) {
            for (Map.Entry opEntry : availableIdentifiers.getOperators().entrySet()) {
                parserContext1.addInput((String)opEntry.getKey(), ((EvaluatorWrapper)opEntry.getValue()).getClass());
            }
        }
        parserContext1.setStrictTypeEnforcement(false);
        parserContext1.setStrongTyping(false);
        try {
            returnType = MVEL.analyze((String)expr, (ParserContext)parserContext1);
        }
        catch (Exception e) {
            return null;
        }
        HashSet<Object> requiredInputs = new HashSet(parserContext1.getInputs().keySet());
        HashMap variables = parserContext1.getVariables();
        if (availableIdentifiers.getThisClass() != null) {
            requiredInputs.removeIf(s -> PropertyTools.getFieldOrAccessor((Class)availableIdentifiers.getThisClass(), (String)s) != null);
        }
        ParserContext parserContext2 = new ParserContext(conf);
        parserContext2.setStrictTypeEnforcement(true);
        parserContext2.setStrongTyping(true);
        for (String string : requiredInputs) {
            if ("this".equals(string)) continue;
            if ("_workingMemory_".equals(string)) {
                parserContext2.addInput(string, InternalWorkingMemory.class);
                continue;
            }
            Class<Rule> cls = availableIdentifiers.resolveType(string);
            if (cls == null && string.equals("rule")) {
                cls = Rule.class;
            }
            if (cls == null) continue;
            parserContext2.addInput(string, cls);
        }
        if (availableIdentifiers.getThisClass() != null) {
            parserContext2.addInput("this", availableIdentifiers.getThisClass());
        }
        try {
            returnType = MVEL.analyze((String)expr, (ParserContext)parserContext2);
        }
        catch (Exception e) {
            return null;
        }
        requiredInputs = new HashSet();
        requiredInputs.addAll(parserContext2.getInputs().keySet());
        requiredInputs.addAll(variables.keySet());
        variables = parserContext2.getVariables();
        MVELAnalysisResult result = MVELExprAnalyzer.analyze(requiredInputs, (BoundIdentifiers)availableIdentifiers);
        result.setReturnType(returnType);
        result.setMvelVariables((Map)variables);
        result.setTypesafe(true);
        return result;
    }
}

