/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.Properties;
import org.jbpm.services.task.identity.AbstractUserGroupInfo;
import org.jbpm.services.task.utils.LdapSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLDAPUserGroupInfo
extends AbstractUserGroupInfo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLDAPUserGroupInfo.class);
    public static final String BIND_USER = "ldap.bind.user";
    public static final String BIND_PWD = "ldap.bind.pwd";
    protected static final String DEFAULT_ROLE_ATTR_ID = "cn";
    protected static final String DEFAULT_USER_ATTR_ID = "uid";
    private Properties config;
    protected LdapSearcher ldapSearcher;

    protected AbstractLDAPUserGroupInfo(String[] requiredProperties, String defaultPropertiesName) {
        String propertiesLocation = System.getProperty(defaultPropertiesName);
        String defaultPropertiesLocation = "classpath:/" + defaultPropertiesName + ".properties";
        Properties config = this.readProperties(propertiesLocation, defaultPropertiesLocation);
        this.initialize(requiredProperties, config);
    }

    protected AbstractLDAPUserGroupInfo(String[] requiredProperties, Properties config) {
        this.initialize(requiredProperties, config);
    }

    private void initialize(String[] requiredProperties, Properties config) {
        this.config = config;
        this.validateProperties(requiredProperties);
        this.copyConfigProperty(BIND_USER, "java.naming.security.principal");
        this.copyConfigProperty(BIND_PWD, "java.naming.security.credentials");
        this.ldapSearcher = new LdapSearcher(this.config);
    }

    private void copyConfigProperty(String sourceKey, String targetKey) {
        String value = this.config.getProperty(sourceKey);
        if (value != null) {
            this.config.setProperty(targetKey, value);
        }
    }

    private void validateProperties(String[] requiredProperties) {
        if (this.config == null) {
            throw new IllegalArgumentException("No configuration found for " + this.getClass().getSimpleName() + ", aborting...");
        }
        StringBuffer missingProperties = new StringBuffer();
        for (String requiredProperty : requiredProperties) {
            if (this.config.containsKey(requiredProperty)) continue;
            if (missingProperties.length() > 0) {
                missingProperties.append(", ");
            }
            missingProperties.append(requiredProperty);
        }
        if (missingProperties.length() > 0) {
            logger.debug("Validation failed due to missing required properties: {}", (Object)missingProperties.toString());
            throw new IllegalArgumentException("Missing required properties to configure " + this.getClass().getSimpleName() + ": " + missingProperties.toString());
        }
    }

    public String getConfigProperty(String key) {
        return this.config.getProperty(key);
    }

    public String getConfigProperty(String key, String defaultValue) {
        return this.config.getProperty(key, defaultValue);
    }
}

