/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.def.StaticDataSetDef;
import org.dashbuilder.dataset.exception.DataSetLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetManagerImpl
implements DataSetManager {
    private static final String DATA_SET_NOT_FOUND = "Data set not found: ";
    protected DataSetDefRegistry dataSetDefRegistry;
    protected DataSetProviderRegistry dataSetProviderRegistry;
    protected StaticDataSetProvider staticDataSetProvider;
    protected boolean pushEnabled = false;
    protected int pushMaxSize = 1024;
    protected Logger log = LoggerFactory.getLogger(DataSetManagerImpl.class);

    public DataSetManagerImpl() {
    }

    public DataSetManagerImpl(DataSetDefRegistry dataSetDefRegistry, DataSetProviderRegistry dataSetProviderRegistry, StaticDataSetProvider staticDataSetProvider, boolean pushEnabled, int pushMaxSize) {
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.dataSetProviderRegistry = dataSetProviderRegistry;
        this.staticDataSetProvider = staticDataSetProvider;
        this.pushEnabled = pushEnabled;
        this.pushMaxSize = pushMaxSize;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public int getPushMaxSize() {
        return this.pushMaxSize;
    }

    public DataSetDefRegistry getDataSetDefRegistry() {
        return this.dataSetDefRegistry;
    }

    public DataSetProviderRegistry getDataSetProviderRegistry() {
        return this.dataSetProviderRegistry;
    }

    public StaticDataSetProvider getStaticDataSetProvider() {
        return this.staticDataSetProvider;
    }

    public DataSet createDataSet(String uuid) {
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        dataSet.setUUID(uuid);
        return dataSet;
    }

    public DataSet getDataSet(String uuid) {
        try {
            DataSetDef dataSetDef = this.dataSetDefRegistry.getDataSetDef(uuid);
            if (dataSetDef == null) {
                throw new RuntimeException(DATA_SET_NOT_FOUND + uuid);
            }
            return this.resolveProvider(dataSetDef).lookupDataSet(dataSetDef, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't fetch the specified data set: " + uuid, e);
        }
    }

    public void registerDataSet(DataSet dataSet) {
        if (dataSet != null) {
            StaticDataSetDef def = new StaticDataSetDef();
            def.setUUID(dataSet.getUUID());
            def.setName(dataSet.getUUID());
            def.setDataSet(dataSet);
            def.setPushEnabled(this.pushEnabled);
            def.setPushMaxSize(Integer.valueOf(this.pushMaxSize));
            this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
            this.staticDataSetProvider.registerDataSet(dataSet);
        }
    }

    public void registerDataSet(DataSet dataSet, List<DataSetPreprocessor> preprocessors) {
        this.registerDataSet(dataSet);
        for (DataSetPreprocessor p : preprocessors) {
            this.dataSetDefRegistry.registerPreprocessor(dataSet.getUUID(), p);
        }
    }

    public DataSet removeDataSet(String uuid) {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return null;
        }
        this.dataSetDefRegistry.removeDataSetDef(uuid);
        return this.staticDataSetProvider.removeDataSet(uuid);
    }

    public DataSet lookupDataSet(DataSetLookup lookup) {
        String uuid = lookup.getDataSetUUID();
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return null;
        }
        DataSetDef dataSetDef = this.dataSetDefRegistry.getDataSetDef(uuid);
        if (dataSetDef == null) {
            throw new RuntimeException(DATA_SET_NOT_FOUND + uuid);
        }
        List dataSetDefPreProcessors = this.dataSetDefRegistry.getDataSetDefPreProcessors(uuid);
        if (dataSetDefPreProcessors != null) {
            for (DataSetPreprocessor p : dataSetDefPreProcessors) {
                p.preprocess(lookup);
            }
        }
        try {
            DataSet dataSet = this.resolveProvider(dataSetDef).lookupDataSet(dataSetDef, lookup);
            List dataSetDefPostProcessors = this.dataSetDefRegistry.getDataSetDefPostProcessors(uuid);
            if (dataSetDefPostProcessors != null) {
                dataSetDefPostProcessors.forEach(post -> post.postProcess(lookup, dataSet));
            }
            return dataSet;
        }
        catch (Exception e) {
            throw new DataSetLookupException(uuid, "Can't lookup on specified data set: " + lookup.getDataSetUUID(), e);
        }
    }

    public DataSet[] lookupDataSets(DataSetLookup[] lookup) {
        DataSet[] result = new DataSet[lookup.length];
        for (int i = 0; i < lookup.length; ++i) {
            result[i] = this.lookupDataSet(lookup[i]);
        }
        return result;
    }

    public DataSetMetadata getDataSetMetadata(String uuid) {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return null;
        }
        DataSetDef dataSetDef = this.dataSetDefRegistry.getDataSetDef(uuid);
        if (dataSetDef == null) {
            throw new RuntimeException(DATA_SET_NOT_FOUND + uuid);
        }
        try {
            return this.resolveProvider(dataSetDef).getDataSetMetadata(dataSetDef);
        }
        catch (Exception e) {
            throw new DataSetLookupException(uuid, "Can't get metadata on specified data set: " + uuid, e);
        }
    }

    public DataSetProvider resolveProvider(DataSetDef dataSetDef) {
        DataSetProvider dataSetProvider;
        DataSetProviderType type = dataSetDef.getProvider();
        if (type != null && (dataSetProvider = this.dataSetProviderRegistry.getDataSetProvider(type)) != null) {
            return dataSetProvider;
        }
        this.log.warn("Please make sure the " + type + " provider has been added to the registry");
        return this.staticDataSetProvider;
    }
}

