/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.dashbuilder.dataset.uuid.UUIDGenerator;

public class UUIDGeneratorImpl
implements UUIDGenerator {
    public String newUuid() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public String newUuidBase64() {
        String uuidStr = this.newUuid();
        return this.uuidToBase64(uuidStr);
    }

    public String uuidToBase64(String str) {
        UUID uuid = UUID.fromString(str);
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return Base64.encodeBase64URLSafeString((byte[])bb.array());
    }

    public String uuidFromBase64(String str) {
        byte[] bytes = Base64.decodeBase64((String)str);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        UUID uuid = new UUID(bb.getLong(), bb.getLong());
        return uuid.toString();
    }
}

