/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.casemgmt.cmmn.core.Definitions;
import org.jbpm.casemgmt.cmmn.core.FileItemDefinition;
import org.jbpm.casemgmt.cmmn.core.Role;
import org.jbpm.casemgmt.cmmn.core.SequenceFlow;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.impl.CancelNodeInstanceAction;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CaseHandler
extends BaseAbstractHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(CaseHandler.class);
    public static final String CONNECTIONS = "BPMN.Connections";
    public static final String LINKS = "BPMN.ThrowLinks";
    public static final String ASSOCIATIONS = "BPMN.Associations";
    public static final String ERRORS = "BPMN.Errors";
    public static final String ESCALATIONS = "BPMN.Escalations";
    static final String PROCESS_INSTANCE_SIGNAL_EVENT = "kcontext.getProcessInstance().signalEvent(\"";
    static final String RUNTIME_SIGNAL_EVENT = "kcontext.getKnowledgeRuntime().signalEvent(\"";
    static final String RUNTIME_MANAGER_SIGNAL_EVENT = "((org.kie.api.runtime.manager.RuntimeManager)kcontext.getKnowledgeRuntime().getEnvironment().get(\"RuntimeManager\")).signalEvent(\"";

    public CaseHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Definitions.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(RuleFlowProcess.class);
            this.validPeers.add(FileItemDefinition.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        Object itemDefinitions;
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String packageName = attrs.getValue("http://www.jboss.org/drools", "packageName");
        String version = attrs.getValue("http://www.jboss.org/drools", "version");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(id);
        if (name == null) {
            name = id;
        }
        process.setName(name);
        process.setType("RuleFlow");
        if (packageName == null) {
            packageName = "org.jbpm.cmmn";
        }
        process.setPackageName(packageName);
        process.setDynamic(true);
        process.setAutoComplete(false);
        if (version != null) {
            process.setVersion(version);
        }
        ((ProcessBuildData)parser.getData()).addProcess((Process)process);
        process.setMetaData("Definitions", parser.getParent());
        Object typedImports = ((ProcessBuildData)parser.getData()).getMetaData("CmmnImports");
        if (typedImports != null) {
            process.setMetaData("CmmnImports", typedImports);
        }
        if ((itemDefinitions = ((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions")) != null) {
            process.setMetaData("ItemDefinitions", itemDefinitions);
        }
        parser.getMetaData().put("idGen", new AtomicInteger(1));
        return process;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        Map roles = (Map)buildData.getMetaData("Roles");
        RuleFlowProcess process = (RuleFlowProcess)parser.getCurrent();
        List connections = (List)process.getMetaData(CONNECTIONS);
        CaseHandler.linkConnections((NodeContainer)process, connections);
        CaseHandler.linkBoundaryEvents((NodeContainer)process);
        this.postProcessNodes(process, (NodeContainer)process, roles);
        return process;
    }

    private static Node findNodeByIdOrUniqueIdInMetadata(NodeContainer nodeContainer, String nodeRef, String errorMsg) {
        Node node = null;
        for (Node containerNode : nodeContainer.getNodes()) {
            if (!nodeRef.equals(containerNode.getMetaData().get("UniqueId"))) continue;
            node = containerNode;
            break;
        }
        if (node == null) {
            throw new IllegalArgumentException(errorMsg);
        }
        return node;
    }

    public Class<?> generateNodeFor() {
        return RuleFlowProcess.class;
    }

    public static void linkConnections(NodeContainer nodeContainer, List<SequenceFlow> connections) {
        if (connections != null) {
            for (SequenceFlow connection : connections) {
                Constraint constraint;
                String sourceRef = connection.getSourceRef();
                Node source = CaseHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, sourceRef, "Could not find source node for connection:" + sourceRef);
                if (source instanceof EventNode) {
                    for (EventFilter eventFilter : ((EventNode)source).getEventFilters()) {
                        if (!(eventFilter instanceof EventTypeFilter) || !"Compensation".equals(((EventTypeFilter)eventFilter).getType())) continue;
                        throw new IllegalArgumentException("A Compensation Boundary Event can only be *associated* with a compensation activity via an Association, not via a Sequence Flow element.");
                    }
                }
                String targetRef = connection.getTargetRef();
                Node target = CaseHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, targetRef, "Could not find target node for connection:" + targetRef);
                ConnectionImpl result = new ConnectionImpl(source, "DROOLS_DEFAULT", target, "DROOLS_DEFAULT");
                result.setMetaData("bendpoints", (Object)connection.getBendpoints());
                result.setMetaData("UniqueId", (Object)connection.getId());
                if ("true".equals(System.getProperty("jbpm.enable.multi.con"))) {
                    NodeImpl nodeImpl = (NodeImpl)source;
                    constraint = CaseHandler.buildConstraint(connection, nodeImpl);
                    if (constraint == null) continue;
                    nodeImpl.addConstraint(new ConnectionRef(connection.getId(), target.getId(), "DROOLS_DEFAULT"), constraint);
                    continue;
                }
                if (!(source instanceof Split)) continue;
                Split split = (Split)source;
                constraint = CaseHandler.buildConstraint(connection, (NodeImpl)split);
                split.addConstraint(new ConnectionRef(target.getId(), "DROOLS_DEFAULT"), constraint);
            }
        }
    }

    public static void linkBoundaryEvents(NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            String attachedTo;
            if (!(node instanceof EventNode) || (attachedTo = (String)node.getMetaData().get("AttachedTo")) == null) continue;
            for (EventFilter filter : ((EventNode)node).getEventFilters()) {
                String type = ((EventTypeFilter)filter).getType();
                Node attachedNode = CaseHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, attachedTo, "Could not find node to attach to: " + attachedTo);
                if (!(attachedNode instanceof StateBasedNode) && !type.equals("Compensation")) {
                    throw new IllegalArgumentException("Boundary events are supported only on StateBasedNode, found node: " + attachedNode.getClass().getName() + " [" + attachedNode.getMetaData().get("UniqueId") + "]");
                }
                if (type.startsWith("Escalation")) {
                    CaseHandler.linkBoundaryEscalationEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.startsWith("Error-")) {
                    CaseHandler.linkBoundaryErrorEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.startsWith("Timer-")) {
                    CaseHandler.linkBoundaryTimerEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (node.getMetaData().get("SignalName") != null || type.startsWith("Message-")) {
                    CaseHandler.linkBoundarySignalEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (!type.startsWith("Condition-")) continue;
                CaseHandler.linkBoundaryConditionEvent(nodeContainer, node, attachedTo, attachedNode);
            }
        }
    }

    private static void linkBoundaryEscalationEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        String escalationCode = (String)node.getMetaData().get("EscalationEvent");
        String escalationStructureRef = (String)node.getMetaData().get("EscalationStructureRef");
        ContextContainer compositeNode = (ContextContainer)attachedNode;
        ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
        if (exceptionScope == null) {
            exceptionScope = new ExceptionScope();
            compositeNode.addContext((Context)exceptionScope);
            compositeNode.setDefaultContext((Context)exceptionScope);
        }
        String variable = ((EventNode)node).getVariableName();
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Escalation-" + attachedTo + "-" + escalationCode + "\", kcontext.getVariable(\"" + variable + "\"));");
        exceptionHandler.setAction((DroolsAction)action);
        exceptionHandler.setFaultVariable(variable);
        exceptionScope.setExceptionHandler(escalationCode, (ExceptionHandler)exceptionHandler);
        if (escalationStructureRef != null) {
            exceptionScope.setExceptionHandler(escalationStructureRef, (ExceptionHandler)exceptionHandler);
        }
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
            cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(cancelAction);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    private static void linkBoundaryErrorEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        ArrayList<DroolsConsequenceAction> actions;
        ContextContainer compositeNode = (ContextContainer)attachedNode;
        ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
        if (exceptionScope == null) {
            exceptionScope = new ExceptionScope();
            compositeNode.addContext((Context)exceptionScope);
            compositeNode.setDefaultContext((Context)exceptionScope);
        }
        String errorCode = (String)node.getMetaData().get("ErrorEvent");
        boolean hasErrorCode = (Boolean)node.getMetaData().get("HasErrorEvent");
        String errorStructureRef = (String)node.getMetaData().get("ErrorStructureRef");
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        String variable = ((EventNode)node).getVariableName();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Error-" + attachedTo + "-" + errorCode + "\", kcontext.getVariable(\"" + variable + "\"));");
        exceptionHandler.setAction((DroolsAction)action);
        exceptionHandler.setFaultVariable(variable);
        exceptionScope.setExceptionHandler(hasErrorCode ? errorCode : null, (ExceptionHandler)exceptionHandler);
        if (errorStructureRef != null) {
            exceptionScope.setExceptionHandler(errorStructureRef, (ExceptionHandler)exceptionHandler);
        }
        if ((actions = ((EventNode)node).getActions("onExit")) == null) {
            actions = new ArrayList<DroolsConsequenceAction>();
        }
        DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
        cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
        actions.add(cancelAction);
        ((EventNode)node).setActions("onExit", actions);
    }

    private static void linkBoundaryTimerEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        StateBasedNode compositeNode = (StateBasedNode)attachedNode;
        String timeDuration = (String)node.getMetaData().get("TimeDuration");
        String timeCycle = (String)node.getMetaData().get("TimeCycle");
        String timeDate = (String)node.getMetaData().get("TimeDate");
        Timer timer = new Timer();
        if (timeDuration != null) {
            timer.setDelay(timeDuration);
            timer.setTimeType(1);
            compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeDuration + "-" + node.getId() + "\", kcontext.getNodeInstance().getId());"));
        } else if (timeCycle != null) {
            int index = timeCycle.indexOf("###");
            if (index != -1) {
                String period = timeCycle.substring(index + 3);
                timeCycle = timeCycle.substring(0, index);
                timer.setPeriod(period);
            }
            timer.setDelay(timeCycle);
            timer.setTimeType(2);
            compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeCycle + (timer.getPeriod() == null ? "" : "###" + timer.getPeriod()) + "-" + node.getId() + "\", kcontext.getNodeInstance().getId());"));
        } else if (timeDate != null) {
            timer.setDate(timeDate);
            timer.setTimeType(3);
            compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeDate + "-" + node.getId() + "\", kcontext.getNodeInstance().getId());"));
        }
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
            cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(cancelAction);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    private static void linkBoundarySignalEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
            action.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    private static void linkBoundaryConditionEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        String processId = ((RuleFlowProcess)nodeContainer).getId();
        String eventType = "RuleFlowStateEvent-" + processId + "-" + ((EventNode)node).getUniqueId() + "-" + attachedTo;
        ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).setType(eventType);
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
            action.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    private void postProcessNodes(RuleFlowProcess process, NodeContainer container, Map<String, Role> roles) {
        ArrayList<String> eventSubProcessHandlers = new ArrayList<String>();
        for (Node node : container.getNodes()) {
            EventNode eventNode;
            HumanTaskNode humanTaskNode;
            Role performer;
            if (node instanceof HumanTaskNode && roles != null && (performer = roles.get((humanTaskNode = (HumanTaskNode)node).getWork().getParameter("ActorId"))) != null) {
                humanTaskNode.getWork().setParameter("ActorId", (Object)performer.getName());
            }
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                String condition = (String)stateNode.getMetaData("Condition");
                ConstraintImpl constraint = new ConstraintImpl();
                constraint.setConstraint(condition);
                constraint.setType("rule");
                for (Connection connection : stateNode.getDefaultOutgoingConnections()) {
                    stateNode.setConstraint(connection, (Constraint)constraint);
                }
                continue;
            }
            if (node instanceof NodeContainer) {
                if (node instanceof EventSubProcessNode) {
                    Node[] nodes;
                    EventSubProcessNode eventSubProcessNode = (EventSubProcessNode)node;
                    for (Node subNode : nodes = eventSubProcessNode.getNodes()) {
                        List triggers;
                        if (subNode == null || !(subNode instanceof StartNode) || (triggers = ((StartNode)subNode).getTriggers()) == null) continue;
                        for (Trigger trigger : triggers) {
                            ConstraintTrigger constraintTrigger;
                            if (trigger instanceof EventTrigger) {
                                List filters = ((EventTrigger)trigger).getEventFilters();
                                for (EventFilter filter : filters) {
                                    if (!(filter instanceof EventTypeFilter)) continue;
                                    eventSubProcessNode.addEvent((EventTypeFilter)filter);
                                    String type = ((EventTypeFilter)filter).getType();
                                    if (!type.startsWith("Error-") && !type.startsWith("Escalation")) continue;
                                    String faultCode = (String)subNode.getMetaData().get("FaultCode");
                                    String replaceRegExp = "Error-|Escalation-";
                                    String signalType = type;
                                    ExceptionScope exceptionScope = (ExceptionScope)((ContextContainer)eventSubProcessNode.getNodeContainer()).getDefaultContext("ExceptionScope");
                                    if (exceptionScope == null) {
                                        exceptionScope = new ExceptionScope();
                                        ((ContextContainer)eventSubProcessNode.getNodeContainer()).addContext((Context)exceptionScope);
                                        ((ContextContainer)eventSubProcessNode.getNodeContainer()).setDefaultContext((Context)exceptionScope);
                                    }
                                    String faultVariable = null;
                                    if (trigger.getInAssociations() != null && !trigger.getInAssociations().isEmpty()) {
                                        faultVariable = ((DataAssociation)trigger.getInAssociations().get(0)).getTarget();
                                    }
                                    ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
                                    DroolsConsequenceAction action = new DroolsConsequenceAction("java", PROCESS_INSTANCE_SIGNAL_EVENT + signalType + "\", " + (faultVariable == null ? "null" : "kcontext.getVariable(\"" + faultVariable + "\")") + ");");
                                    exceptionHandler.setAction((DroolsAction)action);
                                    exceptionHandler.setFaultVariable(faultVariable);
                                    if (faultCode != null) {
                                        String trimmedType = type.replaceFirst(replaceRegExp, "");
                                        exceptionScope.setExceptionHandler(trimmedType, (ExceptionHandler)exceptionHandler);
                                        eventSubProcessHandlers.add(trimmedType);
                                        continue;
                                    }
                                    exceptionScope.setExceptionHandler(faultCode, (ExceptionHandler)exceptionHandler);
                                }
                                continue;
                            }
                            if (!(trigger instanceof ConstraintTrigger) || (constraintTrigger = (ConstraintTrigger)trigger).getConstraint() == null) continue;
                            String processId = ((RuleFlowProcess)container).getId();
                            String type = "RuleFlowStateEventSubProcess-Event-" + processId + "-" + eventSubProcessNode.getUniqueId();
                            EventTypeFilter eventTypeFilter = new EventTypeFilter();
                            eventTypeFilter.setType(type);
                            eventSubProcessNode.addEvent(eventTypeFilter);
                        }
                    }
                }
                this.postProcessNodes(process, (NodeContainer)node, roles);
                continue;
            }
            if (node instanceof EndNode) {
                this.handleIntermediateOrEndThrowCompensationEvent((ExtendedNodeImpl)((EndNode)node));
                continue;
            }
            if (node instanceof ActionNode) {
                this.handleIntermediateOrEndThrowCompensationEvent((ExtendedNodeImpl)((ActionNode)node));
                continue;
            }
            if (!(node instanceof EventNode) || (eventNode = (EventNode)node) instanceof BoundaryEventNode || eventNode.getDefaultIncomingConnections().size() != 0) continue;
            throw new IllegalArgumentException("Event node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection");
        }
        for (Node node : container.getNodes()) {
            FaultNode faultNode;
            if (!(node instanceof FaultNode) || !eventSubProcessHandlers.contains((faultNode = (FaultNode)node).getFaultName())) continue;
            faultNode.setTerminateParent(false);
        }
    }

    private static Constraint buildConstraint(SequenceFlow connection, NodeImpl node) {
        if (connection.getExpression() == null) {
            return null;
        }
        ConstraintImpl constraint = new ConstraintImpl();
        String defaultConnection = (String)node.getMetaData("Default");
        if (defaultConnection != null && defaultConnection.equals(connection.getId())) {
            constraint.setDefault(true);
        }
        if (connection.getName() != null) {
            constraint.setName(connection.getName());
        } else {
            constraint.setName("");
        }
        if (connection.getType() != null) {
            constraint.setType(connection.getType());
        } else {
            constraint.setType("code");
        }
        if (connection.getLanguage() != null) {
            constraint.setDialect(connection.getLanguage());
        }
        if (connection.getExpression() != null) {
            constraint.setConstraint(connection.getExpression());
        }
        constraint.setPriority(connection.getPriority());
        return constraint;
    }

    protected void handleIntermediateOrEndThrowCompensationEvent(ExtendedNodeImpl throwEventNode) {
        if (throwEventNode.getMetaData("compensation-activityRef") != null) {
            String activityRef = (String)throwEventNode.getMetaData().remove("compensation-activityRef");
            NodeContainer nodeParent = throwEventNode.getNodeContainer();
            if (nodeParent instanceof EventSubProcessNode) {
                boolean compensationEventSubProcess = false;
                List startTriggers = ((EventSubProcessNode)nodeParent).findStartNode().getTriggers();
                block0: for (Trigger trigger : startTriggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    for (EventFilter filter : ((EventTrigger)trigger).getEventFilters()) {
                        if (!((EventTypeFilter)filter).getType().equals("Compensation")) continue;
                        compensationEventSubProcess = true;
                        break block0;
                    }
                }
                if (compensationEventSubProcess) {
                    nodeParent = ((NodeImpl)nodeParent).getNodeContainer();
                }
            }
            String parentId = nodeParent instanceof RuleFlowProcess ? ((RuleFlowProcess)nodeParent).getId() : (String)((NodeImpl)nodeParent).getMetaData("UniqueId");
            String compensationEvent = activityRef.length() == 0 ? "implicit:" + parentId : activityRef;
            DroolsConsequenceAction compensationAction = new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Compensation\", \"" + compensationEvent + "\");");
            if (throwEventNode instanceof ActionNode) {
                ((ActionNode)throwEventNode).setAction((DroolsAction)compensationAction);
            } else if (throwEventNode instanceof EndNode) {
                ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
                actions.add(compensationAction);
                ((EndNode)throwEventNode).setActions("onEntry", actions);
            }
        }
    }
}

