/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.HashMap;
import java.util.HashSet;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.casemgmt.cmmn.core.Role;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CaseRoleHandler
extends BaseAbstractHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(CaseRoleHandler.class);

    public CaseRoleHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(RuleFlowProcess.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(Role.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        logger.debug("Found case role with id {} and name {}", (Object)id, (Object)name);
        RuleFlowProcess process = (RuleFlowProcess)parser.getParent(RuleFlowProcess.class);
        String caseRoles = (String)process.getMetaData("customCaseRoles");
        caseRoles = caseRoles == null ? name : caseRoles + "," + name;
        process.setMetaData("customCaseRoles", (Object)caseRoles);
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        HashMap<String, Role> roles = (HashMap<String, Role>)buildData.getMetaData("Roles");
        if (roles == null) {
            roles = new HashMap<String, Role>();
            buildData.setMetaData("Roles", roles);
        }
        Role role = new Role(id, name);
        roles.put(id, role);
        return role;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        return parser.getCurrent();
    }

    public Class<?> generateNodeFor() {
        return Role.class;
    }
}

