/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.casemgmt.cmmn.xml.AbstractCaseNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DecisionTaskHandler
extends AbstractCaseNodeHandler {
    private static final String NAMESPACE_PROP = "namespace";
    private static final String MODEL_PROP = "model";
    private static final String DECISION_PROP = "decision";
    private static final Logger logger = LoggerFactory.getLogger(DecisionTaskHandler.class);

    @Override
    protected Node createNode(Attributes attrs) {
        return new RuleSetNode();
    }

    public Class generateNodeFor() {
        return RuleSetNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        String decisionRef = element.getAttribute("decisionRef");
        if (decisionRef == null) {
            throw new IllegalArgumentException("Decision information is mandatory");
        }
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        ruleSetNode.setRuleFlowGroup(decisionRef);
        ruleSetNode.setLanguage("http://www.jboss.org/drools/rule");
        ruleSetNode.setNamespace((String)ruleSetNode.removeParameter(NAMESPACE_PROP));
        ruleSetNode.setModel((String)ruleSetNode.removeParameter(MODEL_PROP));
        ruleSetNode.setDecision((String)ruleSetNode.removeParameter(DECISION_PROP));
        HashMap<String, String> inputs = new HashMap<String, String>();
        HashMap<String, String> outputs = new HashMap<String, String>();
        HashMap<String, String> inputTypes = new HashMap<String, String>();
        HashMap<String, String> outputTypes = new HashMap<String, String>();
        this.loadDataInputsAndOutputs(element, inputs, outputs, inputTypes, outputTypes, parser);
        ruleSetNode.setMetaData("DataInputs", inputTypes);
        ruleSetNode.setMetaData("DataOutputs", outputTypes);
        for (Map.Entry entry : inputs.entrySet()) {
            ruleSetNode.addInAssociation(new DataAssociation((String)entry.getValue(), (String)entry.getKey(), Collections.emptyList(), null));
        }
        for (Map.Entry entry : outputs.entrySet()) {
            ruleSetNode.addOutAssociation(new DataAssociation((String)entry.getKey(), (String)entry.getValue(), Collections.emptyList(), null));
        }
    }
}

