/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import org.drools.compiler.compiler.DroolsError;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.kie.internal.builder.InternalMessage;
import org.kie.internal.builder.ResultSeverity;

public class DMNKnowledgeBuilderError
extends DroolsError {
    private int[] lines = new int[0];
    private String message;
    private String namespace;
    private ResultSeverity severity;
    private DMNMessage dmnMessage;

    public DMNKnowledgeBuilderError(ResultSeverity severity, Resource resource, String namespace, String message) {
        super(resource);
        this.severity = severity;
        this.namespace = namespace;
        this.message = message;
    }

    public DMNKnowledgeBuilderError(ResultSeverity severity, Resource resource, String message) {
        this(severity, resource, "", message);
    }

    public DMNKnowledgeBuilderError(ResultSeverity severity, String message) {
        this(severity, null, "", message);
    }

    public static DMNKnowledgeBuilderError from(Resource resource, String namespace, DMNMessage m) {
        ResultSeverity rs = ResultSeverity.ERROR;
        switch (m.getLevel()) {
            case ERROR: {
                rs = ResultSeverity.ERROR;
                break;
            }
            case INFO: {
                rs = ResultSeverity.INFO;
                break;
            }
            case WARNING: {
                rs = ResultSeverity.WARNING;
                break;
            }
            default: {
                rs = ResultSeverity.ERROR;
            }
        }
        DMNKnowledgeBuilderError res = new DMNKnowledgeBuilderError(rs, resource, namespace, m.getMessage());
        res.dmnMessage = m;
        return res;
    }

    public ResultSeverity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public int[] getLines() {
        return this.lines;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public DMNMessage getDmnMessage() {
        return this.dmnMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DMNKnowledgeBuilderError [message=");
        sb.append(this.message);
        sb.append(", namespace=");
        sb.append(this.namespace);
        sb.append(", dmnMessage=");
        sb.append(this.dmnMessage);
        sb.append("]");
        return sb.toString();
    }

    public InternalMessage asMessage(long id) {
        if (this.dmnMessage == null) {
            return super.asMessage(id);
        }
        return ((DMNMessageImpl)this.dmnMessage).cloneWith(id, this.getResource().getSourcePath());
    }
}

