/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;

public class DefaultDMNMessagesManager
implements DMNMessageManager {
    private List<DMNMessage> messages = new ArrayList<DMNMessage>();

    public List<DMNMessage> getMessages() {
        return this.messages;
    }

    public List<DMNMessage> getMessages(DMNMessage.Severity ... sevs) {
        List<DMNMessage.Severity> severities = Arrays.asList(sevs);
        return this.messages.stream().filter(m -> severities.contains(m.getSeverity())).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return this.messages.stream().anyMatch(m -> DMNMessage.Severity.ERROR.equals((Object)m.getSeverity()));
    }

    @Override
    public void addAll(List<? extends DMNMessage> messages) {
        for (DMNMessage dMNMessage : messages) {
            this.addMessage(dMNMessage);
        }
    }

    @Override
    public void addAllUnfiltered(List<? extends DMNMessage> messages) {
        for (DMNMessage dMNMessage : messages) {
            this.messages.add(dMNMessage);
        }
    }

    @Override
    public DMNMessage addMessage(DMNMessage newMessage) {
        for (DMNMessage existingMessage : this.messages) {
            if (!this.isDuplicate(existingMessage, newMessage)) continue;
            return existingMessage;
        }
        this.messages.add(newMessage);
        return newMessage;
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source) {
        DMNMessageImpl msg = new DMNMessageImpl(severity, message, messageType, source);
        return this.addMessage(msg);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, Throwable exception) {
        DMNMessageImpl msg = new DMNMessageImpl(severity, message, messageType, source, exception);
        return this.addMessage(msg);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, FEELEvent feelEvent) {
        DMNMessageImpl msg = new DMNMessageImpl(severity, message, messageType, source, feelEvent);
        return this.addMessage(msg);
    }

    private boolean isDuplicate(DMNMessage existingMsg, DMNMessage newMessage) {
        return existingMsg.getMessageType().equals((Object)newMessage.getMessageType()) && existingMsg.getSourceReference() == newMessage.getSourceReference();
    }
}

