/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.date;

import org.dashbuilder.dataset.date.TimeInstant;

public class TimeFrame {
    private TimeInstant from = null;
    private TimeInstant to = null;

    public TimeFrame() {
    }

    public TimeFrame(TimeInstant from, TimeInstant to) {
        this.from = from;
        this.to = to;
    }

    public TimeInstant getFrom() {
        return this.from;
    }

    public void setFrom(TimeInstant from) {
        this.from = from;
    }

    public TimeInstant getTo() {
        return this.to;
    }

    public void setTo(TimeInstant to) {
        this.to = to;
    }

    public static TimeFrame parse(String timeFrameExpr) {
        if (timeFrameExpr == null || timeFrameExpr.length() == 0) {
            throw new IllegalArgumentException("Empty time frame expression");
        }
        String expr = timeFrameExpr.toLowerCase().trim();
        int sep = expr.indexOf("till");
        TimeFrame timeFrame = new TimeFrame();
        if (sep == -1) {
            TimeInstant instant = TimeInstant.parse(expr);
            TimeInstant now = TimeInstant.now();
            if (instant.getTimeInstant().equals(now.getTimeInstant())) {
                throw new IllegalArgumentException("Time frame limits are equals: " + instant);
            }
            if (instant.getTimeInstant().before(now.getTimeInstant())) {
                timeFrame.setFrom(instant);
                timeFrame.setTo(now);
            } else {
                timeFrame.setFrom(now);
                timeFrame.setTo(instant);
            }
        } else {
            String fromExpr = expr.substring(0, sep);
            String toExpr = expr.substring(sep + 4);
            TimeInstant from = TimeInstant.parse(fromExpr);
            TimeInstant to = TimeInstant.parse(toExpr);
            timeFrame.setFrom(from);
            timeFrame.setTo(to);
            if (to.getTimeMode() == null) {
                to.setStartTime(from.getTimeInstant());
            }
        }
        return timeFrame;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.from != null && this.to != null) {
            out.append(this.from.toString());
            out.append(" till ");
            out.append(this.to.toString());
        } else if (this.from != null) {
            out.append(this.from.toString());
        } else if (this.to != null) {
            out.append(this.to.toString());
        }
        return out.toString();
    }
}

