/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.admin.CaseInstanceMigrationService;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseMilestone;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.utils.CaseServiceConfigurator;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskDefinition;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.test.services.AbstractServicesTest;
import org.jbpm.test.services.TestIdentityProvider;
import org.junit.After;
import org.junit.Before;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.QuickTaskSummary;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;

public abstract class AbstractCaseServicesTest
extends AbstractServicesTest {
    protected EntityManagerFactory emf;
    protected DefinitionService bpmn2Service;
    protected RuntimeDataService runtimeDataService;
    protected ProcessService processService;
    protected UserTaskService userTaskService;
    protected QueryService queryService;
    protected CaseRuntimeDataService caseRuntimeDataService;
    protected CaseService caseService;
    protected CaseInstanceMigrationService caseInstanceMigrationService;
    protected ProcessInstanceMigrationService migrationService;
    protected TestIdentityProvider identityProvider;
    protected CaseIdGenerator caseIdGenerator;
    protected AuthorizationManager authorizationManager;
    protected List<String> listenerMvelDefinitions = new ArrayList<String>();
    protected DeploymentUnit deploymentUnit;
    protected CaseServiceConfigurator caseConfigurator;

    public AbstractCaseServicesTest() {
        this.loadCaseServiceConfigurator();
    }

    protected void loadCaseServiceConfigurator() {
        this.caseConfigurator = ServiceLoader.load(CaseServiceConfigurator.class).iterator().next();
    }

    @Before
    public void setUp() throws Exception {
        this.prepareDocumentStorage();
        this.configureServices();
        this.deploymentUnit = this.prepareDeploymentUnit();
    }

    @After
    public void tearDown() {
        this.clearDocumentStorageProperty();
        List<CaseStatus> caseStatuses = Collections.singletonList(CaseStatus.OPEN);
        this.caseRuntimeDataService.getCaseInstances(caseStatuses, (QueryContext)new org.kie.internal.query.QueryContext(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).forEach(caseInstance -> this.caseService.cancelCase(caseInstance.getCaseId()));
        AbstractCaseServicesTest.cleanupSingletonSessionId();
        this.identityProvider.reset();
        if (this.deploymentUnit != null) {
            this.deploymentService.undeploy(this.deploymentUnit);
            this.deploymentUnit = null;
        }
        this.close();
        ServiceRegistry.get().clear();
    }

    @Override
    protected DeploymentUnit createDeploymentUnit(String groupId, String artifactid, String version) throws Exception {
        return this.caseConfigurator.createDeploymentUnit(groupId, artifactid, version);
    }

    @Override
    protected void close() {
        this.caseConfigurator.close();
        EntityManagerFactoryManager.get().clear();
        this.closeDataSource();
    }

    protected void configureServices() {
        this.buildDatasource();
        this.identityProvider = new TestIdentityProvider();
        this.caseConfigurator.configureServices("org.jbpm.domain", (IdentityProvider)this.identityProvider);
        this.authorizationManager = this.caseConfigurator.getAuthorizationManager();
        this.bpmn2Service = this.caseConfigurator.getBpmn2Service();
        this.queryService = this.caseConfigurator.getQueryService();
        this.deploymentService = this.caseConfigurator.getDeploymentService();
        this.runtimeDataService = this.caseConfigurator.getRuntimeDataService();
        this.processService = this.caseConfigurator.getProcessService();
        this.userTaskService = this.caseConfigurator.getUserTaskService();
        this.caseIdGenerator = this.caseConfigurator.getCaseIdGenerator();
        this.caseRuntimeDataService = this.caseConfigurator.getCaseRuntimeDataService();
        this.caseService = this.caseConfigurator.getCaseService();
        this.migrationService = this.caseConfigurator.getMigrationService();
        this.caseInstanceMigrationService = this.caseConfigurator.getCaseInstanceMigrationService();
    }

    @Override
    protected DeploymentDescriptor createDeploymentDescriptor() {
        this.listenerMvelDefinitions.add("new org.jbpm.casemgmt.impl.util.TrackingCaseEventListener()");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        DeploymentDescriptorBuilder ddBuilder = customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_CASE).addMarshalingStrategy(new ObjectModel("mvel", "org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get()", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "StartCaseInstance", "new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession)", new Object[0]));
        this.listenerMvelDefinitions.forEach(listenerDefinition -> ddBuilder.addEventListener(new ObjectModel("mvel", listenerDefinition, new Object[0])));
        this.getProcessListeners().forEach(listener -> ddBuilder.addEventListener(listener));
        this.getWorkItemHandlers().forEach(listener -> ddBuilder.addWorkItemHandler(listener));
        return customDescriptor;
    }

    protected void registerListenerMvelDefinition(String listenerMvelDefinition) {
        this.listenerMvelDefinitions.add(listenerMvelDefinition);
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setBpmn2Service(DefinitionService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    public void setIdentityProvider(TestIdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setCaseRuntimeDataService(CaseRuntimeDataService caseRuntimeDataService) {
        this.caseRuntimeDataService = caseRuntimeDataService;
    }

    protected Map<String, CaseDefinition> mapCases(Collection<CaseDefinition> cases) {
        return cases.stream().collect(Collectors.toMap(CaseDefinition::getId, c -> c));
    }

    protected Map<String, CaseRole> mapRoles(Collection<CaseRole> caseRoles) {
        return caseRoles.stream().collect(Collectors.toMap(CaseRole::getName, c -> c));
    }

    protected Map<String, CaseMilestone> mapMilestones(Collection<CaseMilestone> caseMilestones) {
        return caseMilestones.stream().collect(Collectors.toMap(CaseMilestone::getName, c -> c));
    }

    protected Map<String, CaseStage> mapStages(Collection<CaseStage> caseStages) {
        return caseStages.stream().collect(Collectors.toMap(CaseStage::getName, c -> c));
    }

    protected Map<String, UserTaskDefinition> mapTasksDef(Collection<UserTaskDefinition> tasks) {
        return tasks.stream().collect(Collectors.toMap(UserTaskDefinition::getName, t -> t));
    }

    protected Map<String, AdHocFragment> mapAdHocFragments(Collection<AdHocFragment> adHocFragments) {
        return adHocFragments.stream().collect(Collectors.toMap(AdHocFragment::getName, t -> t));
    }

    protected Map<String, ProcessDefinition> mapProcesses(Collection<ProcessDefinition> processes) {
        return processes.stream().collect(Collectors.toMap(ProcessDefinition::getId, p -> p));
    }

    protected Map<String, NodeInstanceDesc> mapNodeInstances(Collection<NodeInstanceDesc> nodes) {
        return nodes.stream().collect(Collectors.toMap(NodeInstanceDesc::getName, n -> n));
    }

    protected Map<String, TaskSummary> mapTaskSummaries(Collection<TaskSummary> tasks) {
        return tasks.stream().collect(Collectors.toMap(QuickTaskSummary::getName, t -> t));
    }

    protected Map<Long, ProcessInstanceDesc> mapProcessesInstances(Collection<ProcessInstanceDesc> processes) {
        return processes.stream().collect(Collectors.toMap(ProcessInstanceDesc::getId, p -> p));
    }
}

