/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.services.task.assignment.UserTaskLoad;
import org.jbpm.services.task.assignment.impl.AbstractLoadCalculator;
import org.jbpm.services.task.assignment.impl.AssignmentImpl;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskContext;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCountLoadCalculator
extends AbstractLoadCalculator {
    private static final String IDENTIFIER = "TaskCountLoadCalculator";
    private static final Logger logger = LoggerFactory.getLogger(TaskCountLoadCalculator.class);
    private static final String SINGLE_USER_QUERY = "select new Integer(count(t)) from TaskImpl t where t.taskData.actualOwner.id = :owner and t.taskData.status in ('Reserved', 'InProgress', 'Suspended') ";
    private static final String MULTI_USER_QUERY = "select new org.jbpm.services.task.assignment.impl.AssignmentImpl(t.taskData.actualOwner.id, count(t)) from TaskImpl t where t.taskData.actualOwner.id in (:owners) and t.taskData.status in ('Reserved', 'InProgress', 'Suspended') group by t.taskData.actualOwner order by count(t) asc, t.taskData.actualOwner.id asc";
    Function<AssignmentImpl, String> assignKey = assignment -> assignment.getUser();

    public TaskCountLoadCalculator() {
        super(IDENTIFIER);
    }

    @Override
    public UserTaskLoad getUserTaskLoad(User user, TaskContext context) {
        UserTaskLoad load = new UserTaskLoad(this.getIdentifier(), user);
        TaskPersistenceContext persistenceContext = ((org.jbpm.services.task.commands.TaskContext)context).getPersistenceContext();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("owner", user.getId());
        logger.debug("DB query to be used for finding assignments :: '{}'", (Object)this.getSingleUserQuery());
        List assignmentCounts = (List)persistenceContext.queryStringWithParametersInTransaction(this.getSingleUserQuery(), params, ClassUtil.castClass(List.class));
        if (assignmentCounts != null && !assignmentCounts.isEmpty()) {
            load.setCalculatedLoad(new Double(((Integer)assignmentCounts.get(0)).intValue()));
        } else {
            load.setCalculatedLoad(new Double(0.0));
        }
        return load;
    }

    @Override
    public Collection<UserTaskLoad> getUserTaskLoads(List<User> users, TaskContext context) {
        ArrayList<UserTaskLoad> userTaskLoads = new ArrayList<UserTaskLoad>();
        List userIds = users.stream().map(user -> user.getId()).collect(Collectors.toList());
        TaskPersistenceContext persistenceContext = ((org.jbpm.services.task.commands.TaskContext)context).getPersistenceContext();
        HashMap params = new HashMap();
        params.put("owners", userIds);
        logger.debug("DB query to be used for finding assignments :: '{}'", (Object)this.getMultiUserQuery());
        List assignments = (List)persistenceContext.queryStringWithParametersInTransaction(this.getMultiUserQuery(), params, ClassUtil.castClass(List.class));
        Map<String, AssignmentImpl> assignmentMap = assignments.stream().collect(Collectors.toMap(this.assignKey, assign -> assign));
        if (assignments != null && !assignments.isEmpty()) {
            users.forEach(usr -> {
                String uid = usr.getId();
                if (assignmentMap.containsKey(uid)) {
                    Long loadValue = ((AssignmentImpl)((Object)((Object)assignmentMap.get(uid)))).getCurrentlyAssigned();
                    userTaskLoads.add(new UserTaskLoad(this.getIdentifier(), (User)usr, new Double(loadValue != null ? (double)loadValue.longValue() : 0.0)));
                } else {
                    userTaskLoads.add(new UserTaskLoad(this.getIdentifier(), (User)usr, new Double(0.0)));
                }
            });
        } else {
            users.forEach(u -> userTaskLoads.add(new UserTaskLoad(this.getIdentifier(), (User)u, new Double(0.0))));
        }
        return userTaskLoads;
    }

    private String getSingleUserQuery() {
        return SINGLE_USER_QUERY;
    }

    private String getMultiUserQuery() {
        return MULTI_USER_QUERY;
    }
}

