/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import org.drools.core.fluent.impl.Batch;
import org.drools.core.fluent.impl.InternalExecutable;
import org.drools.core.runtime.ChainableRunner;
import org.drools.core.runtime.InternalLocalRunner;
import org.jbpm.services.task.commands.CompositeCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.TaskEventSupport;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.RequestContext;
import org.kie.internal.identity.IdentityProvider;

public class TaskCommandExecutorImpl
implements InternalLocalRunner {
    private Environment environment;
    private TaskEventSupport taskEventSupport;
    private InternalLocalRunner commandService = new SelfExecutionCommandService(this);

    public TaskCommandExecutorImpl(Environment environment, TaskEventSupport taskEventSupport) {
        this.environment = environment;
        this.taskEventSupport = taskEventSupport;
    }

    public RequestContext execute(Executable executable, RequestContext ctx) {
        return (RequestContext)this.commandService.execute(executable, (Context)ctx);
    }

    public <T> T execute(Command<T> command) {
        return (T)this.commandService.execute(command);
    }

    public void addInterceptor(ChainableRunner interceptor) {
        interceptor.setNext((ExecutableRunner)this.commandService);
        this.commandService = interceptor;
    }

    public RequestContext createContext() {
        if (this.commandService instanceof SelfExecutionCommandService) {
            return new TaskContext();
        }
        return new TaskContext(this.commandService.createContext(), this.environment, this.taskEventSupport);
    }

    protected void addUserIdToContext(TaskCommand<?> command, RequestContext context) {
        if (context instanceof org.kie.internal.task.api.TaskContext) {
            org.kie.internal.task.api.TaskContext taskContext = (org.kie.internal.task.api.TaskContext)context;
            IdentityProvider identityProvider = (IdentityProvider)taskContext.get("org.kie.internal.identity.IdentityProvider");
            String userId = command.getUserId();
            if (command instanceof CompositeCommand) {
                userId = ((CompositeCommand)command).getMainCommand().getUserId();
            }
            if (userId == null && identityProvider != null) {
                userId = identityProvider.getName();
                command.setUserId(userId);
            }
            taskContext.setUserId(userId);
        }
    }

    private class SelfExecutionCommandService
    implements InternalLocalRunner {
        private TaskCommandExecutorImpl owner;

        SelfExecutionCommandService(TaskCommandExecutorImpl owner) {
            this.owner = owner;
        }

        public RequestContext execute(Executable executable, RequestContext context) {
            for (Batch batch : ((InternalExecutable)executable).getBatches()) {
                for (Command command : batch.getCommands()) {
                    if (command instanceof TaskCommand) {
                        TaskContext ctx = new TaskContext((Context)context, TaskCommandExecutorImpl.this.environment, TaskCommandExecutorImpl.this.taskEventSupport);
                        TaskCommandExecutorImpl.this.addUserIdToContext((TaskCommand)command, ctx);
                        Object result = ((ExecutableCommand)command).execute((Context)ctx);
                        context.set("Result", result);
                        continue;
                    }
                    throw new IllegalArgumentException("Task service can only execute task commands");
                }
            }
            return context;
        }

        public RequestContext createContext() {
            return this.owner.createContext();
        }
    }
}

