/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.deadlines.notifications.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jbpm.services.task.deadlines.NotificationListener;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.NotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationListenerManager {
    private static final Logger logger = LoggerFactory.getLogger(NotificationListenerManager.class);
    private static ServiceLoader<NotificationListener> listenersLoaded = ServiceLoader.load(NotificationListener.class);
    private static NotificationListenerManager INSTANCE = new NotificationListenerManager();
    private List<NotificationListener> listeners = new ArrayList<NotificationListener>();

    private NotificationListenerManager() {
        for (NotificationListener listener : listenersLoaded) {
            this.listeners.add(listener);
        }
    }

    public void broadcast(NotificationEvent event, UserInfo userInfo) {
        for (NotificationListener listener : this.listeners) {
            try {
                logger.debug("Sending notification {} to {} with params {}", new Object[]{event, listener, userInfo});
                listener.onNotification(event, userInfo);
            }
            catch (Exception e) {
                logger.warn("Exception encountered while notifying listener {} with event {} - error {}", new Object[]{listener, event, e.getMessage()});
            }
        }
    }

    public static NotificationListenerManager get() {
        return INSTANCE;
    }
}

