/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.List;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskIdentityService;
import org.kie.internal.task.api.TaskPersistenceContext;

public class TaskIdentityServiceImpl
implements TaskIdentityService {
    private TaskPersistenceContext persistenceContext;

    public TaskIdentityServiceImpl() {
    }

    public TaskIdentityServiceImpl(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void addUser(User user) {
        this.persistenceContext.persistUser(user);
    }

    public void addGroup(Group group) {
        this.persistenceContext.persistGroup(group);
    }

    public void removeGroup(String groupId) {
        Group group = this.persistenceContext.findGroup(groupId);
        this.persistenceContext.remove((Object)group);
    }

    public void removeUser(String userId) {
        User user = this.persistenceContext.findUser(userId);
        this.persistenceContext.remove((Object)user);
    }

    public List<User> getUsers() {
        return (List)this.persistenceContext.queryStringInTransaction("from User", ClassUtil.castClass(List.class));
    }

    public List<Group> getGroups() {
        return (List)this.persistenceContext.queryStringInTransaction("from Group", ClassUtil.castClass(List.class));
    }

    public User getUserById(String userId) {
        return this.persistenceContext.findUser(userId);
    }

    public Group getGroupById(String groupId) {
        return this.persistenceContext.findGroup(groupId);
    }

    public OrganizationalEntity getOrganizationalEntityById(String entityId) {
        return this.persistenceContext.findOrgEntity(entityId);
    }
}

