/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.exception.CannotAddTaskException;
import org.kie.api.task.model.User;
import org.kie.internal.task.exception.TaskException;

public class TaskServiceRequest {
    private String type;
    private User user;
    private Map<String, Object> parameters;
    private boolean allowed = true;
    private List<String> reasons;
    private Class<? extends TaskException> exceptionClass;

    public TaskServiceRequest(String type, User user, Map<String, Object> parameters) {
        this.type = type;
        this.user = user;
        this.parameters = parameters;
    }

    public String getType() {
        return this.type;
    }

    public User getUser() {
        return this.user;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public void addReason(String reason) {
        if (this.reasons == null) {
            this.reasons = new ArrayList<String>();
        }
        this.reasons.add(reason);
    }

    public TaskException getException(String message) {
        if (this.exceptionClass != null) {
            try {
                return this.exceptionClass.getConstructor(String.class).newInstance(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new CannotAddTaskException(message);
    }

    public Class<? extends TaskException> getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(Class<? extends TaskException> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }
}

