/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.jpa.event.internal.AbstractCallback;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.property.access.spi.Getter;

final class EmbeddableCallback
extends AbstractCallback {
    private final Getter embeddableGetter;
    private final Method callbackMethod;

    EmbeddableCallback(Getter embeddableGetter, Method callbackMethod, CallbackType callbackType) {
        super(callbackType);
        this.embeddableGetter = embeddableGetter;
        this.callbackMethod = callbackMethod;
    }

    @Override
    public boolean performCallback(Object entity) {
        try {
            Object embeddable = this.embeddableGetter.get(entity);
            this.callbackMethod.invoke(embeddable, new Object[0]);
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

