/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.tree;

import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.ClassifierNode;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.CountingBranchNode;
import org.dmg.pmml.tree.CountingLeafNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.NodeTransformer;

public class DefaultNodeTransformer
implements NodeTransformer {
    public static final DefaultNodeTransformer INSTANCE = new DefaultNodeTransformer();

    @Override
    public Node fromComplexNode(ComplexNode complexNode) {
        if (complexNode.hasExtensions() || complexNode.getPartition() != null || complexNode.getEmbeddedModel() != null) {
            return complexNode;
        }
        if (complexNode.hasScoreDistributions()) {
            return new ClassifierNode(complexNode);
        }
        Number recordCount = complexNode.getRecordCount();
        if (complexNode.hasNodes()) {
            if (recordCount != null) {
                return new CountingBranchNode(complexNode);
            }
            return new BranchNode(complexNode);
        }
        if (recordCount != null) {
            return new CountingLeafNode(complexNode);
        }
        return new LeafNode(complexNode);
    }

    @Override
    public ComplexNode toComplexNode(Node node) {
        if (node instanceof ComplexNode) {
            ComplexNode complexNode = (ComplexNode)node;
            return complexNode;
        }
        ComplexNode complexNode = new ComplexNode(node);
        return complexNode;
    }
}

