/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.resource.jdbc.BaseProxyHandlerClass;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcPreparedStatementHandle
extends BaseProxyHandlerClass {
    private PreparedStatement delegate;
    private boolean pretendClosed = false;
    private JdbcPooledConnection parentConnection;
    private final String sql;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private Integer resultSetHoldability;
    private Integer autoGeneratedKeys;
    private int[] columnIndexes;
    private String[] columnNames;

    public JdbcPreparedStatementHandle(String sql) {
        this.sql = sql;
    }

    public JdbcPreparedStatementHandle(String sql, int autoGeneratedKeys) {
        this.sql = sql;
        this.autoGeneratedKeys = new Integer(autoGeneratedKeys);
    }

    public JdbcPreparedStatementHandle(String sql, int resultSetType, int resultSetConcurrency) {
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public JdbcPreparedStatementHandle(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = new Integer(resultSetHoldability);
    }

    public JdbcPreparedStatementHandle(String sql, int[] columnIndexes) {
        this.sql = sql;
        this.columnIndexes = new int[columnIndexes.length];
        System.arraycopy(columnIndexes, 0, this.columnIndexes, 0, columnIndexes.length);
    }

    public JdbcPreparedStatementHandle(String sql, String[] columnNames) {
        this.sql = sql;
        this.columnNames = new String[columnNames.length];
        System.arraycopy(columnNames, 0, this.columnNames, 0, columnNames.length);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.delegate.getClass());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.delegate.getClass())) {
            return (T)this.delegate;
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for interface " + iface.getName());
    }

    protected void setPooledConnection(JdbcPooledConnection pooledConnection) {
        this.parentConnection = pooledConnection;
    }

    protected JdbcPooledConnection getPooledConnection() {
        return this.parentConnection;
    }

    private PreparedStatement getDelegate() throws SQLException {
        if (this.pretendClosed) {
            throw new SQLException("prepared statement closed");
        }
        return this.delegate;
    }

    protected PreparedStatement getDelegateUnchecked() {
        return this.delegate;
    }

    protected void setDelegate(PreparedStatement delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getProxiedDelegate() throws Exception {
        return this.getDelegate();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JdbcPreparedStatementHandle)) {
            return false;
        }
        JdbcPreparedStatementHandle otherStmt = (JdbcPreparedStatementHandle)obj;
        if (!this.sql.equals(otherStmt.sql)) {
            return false;
        }
        if (this.resultSetType != otherStmt.resultSetType) {
            return false;
        }
        if (this.resultSetConcurrency != otherStmt.resultSetConcurrency) {
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, otherStmt.columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this.columnNames, otherStmt.columnNames)) {
            return false;
        }
        if (this.autoGeneratedKeys == null && otherStmt.autoGeneratedKeys != null || this.autoGeneratedKeys != null && !this.autoGeneratedKeys.equals(otherStmt.autoGeneratedKeys)) {
            return false;
        }
        return (this.resultSetHoldability != null || otherStmt.resultSetHoldability == null) && (this.resultSetHoldability == null || this.resultSetHoldability.equals(otherStmt.resultSetHoldability));
    }

    public int hashCode() {
        return this.sql != null ? this.sql.hashCode() : System.identityHashCode(this);
    }

    public String toString() {
        return "a JdbcPreparedStatementHandle with sql=[" + this.sql + "]";
    }

    public void close() throws SQLException {
        if (!this.pretendClosed) {
            this.delegate.clearParameters();
            this.parentConnection.putCachedStatement(this);
        }
        this.pretendClosed = true;
    }

    public boolean isClosed() throws SQLException {
        return this.pretendClosed;
    }
}

