/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.filter;

import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.engine.filter.DataSetFilterContext;
import org.dashbuilder.dataset.filter.ColumnFilter;

public abstract class DataSetFunction {
    protected DataSetFilterContext context;
    protected String columnId;
    protected DataColumn dataColumn;

    public DataSetFunction() {
    }

    public DataSetFunction(DataSetFilterContext ctx, ColumnFilter filter) {
        this.context = ctx;
        this.columnId = filter.getColumnId();
    }

    public DataSetFilterContext getContext() {
        return this.context;
    }

    public void setContext(DataSetFilterContext context) {
        this.context = context;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
        this.dataColumn = null;
        if (columnId != null) {
            this.dataColumn = this.context.getDataSet().getColumnById(columnId);
        }
    }

    public DataColumn getDataColumn() {
        if (this.dataColumn != null) {
            return this.dataColumn;
        }
        if (this.columnId == null) {
            return null;
        }
        this.dataColumn = this.context.getDataSet().getColumnById(this.columnId);
        return this.dataColumn;
    }

    public abstract boolean pass();
}

