/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.index;

import org.dashbuilder.dataset.engine.index.stats.MemSizeFormatter;
import org.dashbuilder.dataset.engine.index.visitor.DataSetIndexVisitor;
import org.dashbuilder.dataset.impl.MemSizeEstimator;

public abstract class DataSetIndexElement {
    long buildTime = 0L;
    int reuseHits = 0;

    DataSetIndexElement(long buildTime) {
        this.buildTime = buildTime;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(long buildTime) {
        this.buildTime = buildTime;
    }

    public int getReuseHits() {
        return this.reuseHits;
    }

    public void reuseHit() {
        ++this.reuseHits;
    }

    public long getReuseTime() {
        return this.buildTime * (long)this.reuseHits;
    }

    public void acceptVisitor(DataSetIndexVisitor visitor) {
        visitor.visit(this);
    }

    public long getEstimatedSize() {
        return MemSizeEstimator.sizeOfLong + MemSizeEstimator.sizeOfInteger;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        String simpleName = this.getClass().getName();
        int dotIdx = simpleName.lastIndexOf(46);
        if (dotIdx != -1) {
            simpleName = simpleName.substring(dotIdx + 1);
        }
        out.append(simpleName).append(" ");
        out.append(MemSizeFormatter.formatSize(this.getEstimatedSize())).append(" ");
        out.append((double)this.getBuildTime() / 1000000.0).append(" secs (").append(this.getReuseHits()).append(")");
        return out.toString();
    }
}

