/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.index;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.dataset.engine.index.DataSetGroupIndex;
import org.dashbuilder.dataset.engine.index.DataSetIndexNode;
import org.dashbuilder.dataset.engine.index.DataSetIntervalIndexHolder;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.MemSizeEstimator;

public class DataSetIntervalIndex
extends DataSetIndexNode
implements DataSetIntervalIndexHolder {
    String intervalName = null;
    String intervalType = null;
    Object minValue = null;
    Object maxValue = null;

    public DataSetIntervalIndex(DataSetGroupIndex parent, String intervalName) {
        super(parent, null, 0L);
        this.intervalName = intervalName;
    }

    public DataSetIntervalIndex(DataSetGroupIndex parent, Interval interval) {
        super(parent, interval.getRows(), 0L);
        this.intervalName = interval.getName();
        this.intervalType = interval.getType();
        this.minValue = interval.getMinValue();
        this.maxValue = interval.getMaxValue();
    }

    @Override
    public List<DataSetIntervalIndex> getIntervalIndexes() {
        return Arrays.asList(this);
    }

    public String getName() {
        return this.intervalName;
    }

    @Override
    public long getEstimatedSize() {
        long result = super.getEstimatedSize();
        if (this.intervalName != null) {
            result += (long)MemSizeEstimator.sizeOfString((String)this.intervalName);
        }
        return result;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder(this.intervalName);
        out.append(" ").append(super.toString());
        return out.toString();
    }
}

