/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionSynchronizationRegistry;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionSynchronization;
import org.drools.persistence.api.TransactionSynchronizationRegistryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManagedTransactionManager
implements TransactionManager {
    private static Logger logger = LoggerFactory.getLogger(ContainerManagedTransactionManager.class);
    protected TransactionSynchronizationRegistry txSyncRegistry = (TransactionSynchronizationRegistry)this.findTransactionSynchronizationRegistry();

    public boolean begin() {
        return false;
    }

    public void commit(boolean arg0) {
    }

    public int getStatus() {
        return 4;
    }

    public void registerTransactionSynchronization(TransactionSynchronization arg0) {
        if (this.txSyncRegistry != null) {
            TransactionSynchronizationRegistryHelper.registerTransactionSynchronization((Object)this.txSyncRegistry, (TransactionSynchronization)arg0);
        }
    }

    public void rollback(boolean arg0) {
    }

    protected Object findTransactionSynchronizationRegistry() {
        String jndiName = "java:comp/TransactionSynchronizationRegistry";
        try {
            InitialContext context = new InitialContext();
            Object tsrObject = context.lookup(jndiName);
            return tsrObject;
        }
        catch (NamingException ex) {
            logger.warn("Error when getting TransactionSynchronizationRegistry from JNDI ", (Throwable)ex);
            String customJndiLocation = System.getProperty("jbpm.tsr.jndi.lookup", "java:jboss/TransactionSynchronizationRegistry");
            try {
                Object tsrObject = InitialContext.doLookup(customJndiLocation);
                logger.debug("JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)customJndiLocation);
                return tsrObject;
            }
            catch (Exception e1) {
                logger.debug("No JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)customJndiLocation, (Object)ex);
                return null;
            }
        }
    }

    public void putResource(Object key, Object resource) {
        TransactionSynchronizationRegistryHelper.putResource((Object)this.txSyncRegistry, (Object)key, (Object)resource);
    }

    public Object getResource(Object key) {
        return TransactionSynchronizationRegistryHelper.getResource((Object)this.txSyncRegistry, (Object)key);
    }
}

