/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataprovider.sql.dialect.DB2Dialect;
import org.dashbuilder.dataprovider.sql.dialect.DefaultDialect;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.dialect.H2Dialect;
import org.dashbuilder.dataprovider.sql.dialect.MonetDBDialect;
import org.dashbuilder.dataprovider.sql.dialect.MySQLDialect;
import org.dashbuilder.dataprovider.sql.dialect.OracleDialect;
import org.dashbuilder.dataprovider.sql.dialect.OracleLegacyDialect;
import org.dashbuilder.dataprovider.sql.dialect.PostgresDialect;
import org.dashbuilder.dataprovider.sql.dialect.SQLServerDialect;
import org.dashbuilder.dataprovider.sql.dialect.SybaseASEDialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.SQLDataSourceDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtils {
    public static final Dialect DEFAULT = new DefaultDialect();
    public static final Dialect H2 = new H2Dialect();
    public static final Dialect MYSQL = new MySQLDialect();
    public static final Dialect POSTGRES = new PostgresDialect();
    public static final Dialect ORACLE = new OracleDialect();
    public static final Dialect ORACLE_LEGACY = new OracleLegacyDialect();
    public static final Dialect SQLSERVER = new SQLServerDialect();
    public static final Dialect DB2 = new DB2Dialect();
    public static final Dialect SYBASE_ASE = new SybaseASEDialect();
    public static final Dialect MONETDB = new MonetDBDialect();
    private static final Logger log = LoggerFactory.getLogger(JDBCUtils.class);
    public static final String[] QUOTES = new String[]{"\"", "'", "`", "\u00b4"};

    public static List<SQLDataSourceDef> listDatasourceDefs() {
        String[] namespaces;
        ArrayList<SQLDataSourceDef> result = new ArrayList<SQLDataSourceDef>();
        for (String namespace : namespaces = new String[]{"java:comp/env/jdbc/", "java:jboss/datasources/"}) {
            try {
                InitialContext ctx = new InitialContext();
                NamingEnumeration<NameClassPair> list = ctx.list(namespace);
                while (list.hasMoreElements()) {
                    NameClassPair next = list.next();
                    String name = next.getName();
                    String jndiPath = namespace + name;
                    SQLDataSourceDef dsDef = new SQLDataSourceDef(jndiPath, name);
                    result.add(dsDef);
                }
            }
            catch (NamingException e) {
                log.warn("JNDI namespace " + namespace + " error: " + e.getMessage());
            }
        }
        return result;
    }

    public static void execute(Connection connection, String sql) throws SQLException {
        try {
            if (log.isDebugEnabled()) {
                log.debug(sql);
            }
            connection.createStatement().execute(sql);
        }
        catch (SQLException e) {
            log.error(sql);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T metadata(Connection connection, String sql, Function<ResultSetMetaData, T> callback) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            if (log.isDebugEnabled()) {
                log.debug(sql);
            }
            ResultSetMetaData resultSetMetaData = callback.apply(ps.getMetaData());
            return (T)resultSetMetaData;
        }
        catch (SQLException e) {
            log.error(sql);
            throw e;
        }
    }

    public static ResultSet executeQuery(Connection connection, String sql) throws SQLException {
        try {
            if (log.isDebugEnabled()) {
                log.debug(sql);
            }
            return connection.createStatement().executeQuery(sql);
        }
        catch (SQLException e) {
            log.error(sql);
            throw e;
        }
    }

    public static Dialect dialect(Connection connection) {
        try {
            DatabaseMetaData m = connection.getMetaData();
            String url = m.getURL();
            if (!StringUtils.isBlank((CharSequence)url)) {
                return JDBCUtils.dialect(url, m.getDatabaseMajorVersion());
            }
            String dbName = m.getDatabaseProductName();
            return JDBCUtils.dialect(dbName.toLowerCase());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return DEFAULT;
        }
    }

    public static Dialect dialect(String url, int majorVersion) {
        if (url.contains(":h2:")) {
            return H2;
        }
        if (url.contains(":mysql:")) {
            return MYSQL;
        }
        if (url.contains(":mariadb:")) {
            return MYSQL;
        }
        if (url.contains(":postgresql:")) {
            return POSTGRES;
        }
        if (url.contains(":oracle:")) {
            if (majorVersion < 12) {
                return ORACLE_LEGACY;
            }
            return ORACLE;
        }
        if (url.contains(":sqlserver:")) {
            return SQLSERVER;
        }
        if (url.contains(":db2:")) {
            return DB2;
        }
        if (url.contains(":sybase:")) {
            return SYBASE_ASE;
        }
        if (url.contains(":monetdb:")) {
            return MONETDB;
        }
        return DEFAULT;
    }

    public static Dialect dialect(String dbName) {
        if (dbName.contains("h2")) {
            return H2;
        }
        if (dbName.contains("mysql")) {
            return MYSQL;
        }
        if (dbName.contains("postgre") || dbName.contains("enterprisedb")) {
            return POSTGRES;
        }
        if (dbName.contains("oracle")) {
            return ORACLE;
        }
        if (dbName.contains("microsoft") || dbName.contains("sqlserver") || dbName.contains("sql server")) {
            return SQLSERVER;
        }
        if (dbName.contains("db2")) {
            return DB2;
        }
        if (dbName.contains("ase") || dbName.contains("adaptive")) {
            return SYBASE_ASE;
        }
        if (dbName.contains("monet")) {
            return MONETDB;
        }
        return DEFAULT;
    }

    public static List<Column> getColumns(ResultSet resultSet, String[] exclude) throws SQLException {
        return JDBCUtils.getColumns(resultSet.getMetaData(), exclude);
    }

    public static List<Column> getColumns(ResultSetMetaData meta, String[] exclude) throws SQLException {
        ArrayList<Column> columnList = new ArrayList<Column>();
        List<Object> columnExcluded = exclude == null ? new ArrayList() : Arrays.asList(exclude);
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            ColumnType type;
            String name = meta.getColumnName(i);
            String alias = meta.getColumnLabel(i);
            if (alias != null && !alias.trim().isEmpty()) {
                name = alias.trim();
            }
            if (columnExcluded.contains(name) || columnExcluded.contains(alias) || (type = JDBCUtils.calculateType(meta.getColumnType(i))) == null) continue;
            int size = meta.getColumnDisplaySize(i);
            Column column = SQLFactory.column(name, type, size);
            columnList.add(column);
        }
        return columnList;
    }

    public static String fixCase(Connection connection, String id) {
        try {
            DatabaseMetaData meta = connection.getMetaData();
            if (meta.storesLowerCaseIdentifiers()) {
                return JDBCUtils.changeCaseExcludeQuotes(id, false);
            }
            if (meta.storesUpperCaseIdentifiers()) {
                return JDBCUtils.changeCaseExcludeQuotes(id, true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    public static List<String> getWordsBetweenQuotes(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null) {
            for (int i = 0; i < QUOTES.length; ++i) {
                String quote = QUOTES[i];
                String[] words = StringUtils.substringsBetween((String)s, (String)quote, (String)quote);
                if (words == null) continue;
                result.addAll(Arrays.asList(words));
            }
        }
        return result;
    }

    public static String changeCaseExcludeQuotes(String s, boolean upper) {
        List<String> keepList = JDBCUtils.getWordsBetweenQuotes(s);
        String tmpStr = upper ? s.toUpperCase() : s.toLowerCase();
        for (String word : keepList) {
            String tmpWord = upper ? word.toUpperCase() : word.toLowerCase();
            for (int i = 0; i < QUOTES.length; ++i) {
                String quote = QUOTES[i];
                tmpStr = StringUtils.replace((String)tmpStr, (String)(quote + tmpWord + quote), (String)(quote + word + quote));
            }
        }
        return tmpStr;
    }

    public static ColumnType calculateType(int sqlDataType) {
        switch (sqlDataType) {
            case -15: 
            case -9: 
            case -7: 
            case 1: 
            case 12: 
            case 16: {
                return ColumnType.LABEL;
            }
            case -16: 
            case -1: 
            case 2005: {
                return ColumnType.TEXT;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ColumnType.NUMBER;
            }
            case 91: 
            case 92: 
            case 93: {
                return ColumnType.DATE;
            }
        }
        return null;
    }

    public static String clobToString(Clob value) {
        String result = "";
        try (Reader valueReader = value.getCharacterStream();){
            result = IOUtils.toString((Reader)valueReader);
        }
        catch (Exception e) {
            log.debug("Not able to convert Clob", (Throwable)e);
        }
        return result;
    }
}

