/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.cdi.impl.jpa;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.event.ExecutorEventSupportImpl;
import org.jbpm.executor.impl.jpa.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.jpa.JPAExecutorStoreService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.executor.Executor;
import org.kie.api.executor.ExecutorAdminService;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.runtime.CommandExecutor;

@ApplicationScoped
public class JPAExecutorServiceProducer {
    @Inject
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;
    private ExecutorEventSupportImpl eventSupport = new ExecutorEventSupportImpl();
    private ExecutorService service;

    @PostConstruct
    public void setup() {
        this.service = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf, (ExecutorEventSupportImpl)this.eventSupport);
    }

    @Produces
    public ExecutorService produceExecutorService() {
        return this.service;
    }

    @Produces
    public Executor produceExecutor() {
        return ((ExecutorServiceImpl)this.service).getExecutor();
    }

    @Produces
    public ExecutorEventSupportImpl produceExecutorEventSupport() {
        return this.eventSupport;
    }

    @Produces
    public ExecutorStoreService produceStoreService() {
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        storeService.setCommandService((CommandExecutor)commandService);
        storeService.setEmf(this.emf);
        return storeService;
    }

    @Produces
    public ExecutorAdminService produceAdminService() {
        ExecutorRequestAdminServiceImpl adminService = new ExecutorRequestAdminServiceImpl();
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        adminService.setCommandService((CommandExecutor)commandService);
        return adminService;
    }

    @Produces
    public ExecutorQueryService produceQueryService() {
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        queryService.setCommandService((CommandExecutor)commandService);
        return queryService;
    }
}

