/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.optaplanner.core.impl.score.stream.drools.common.GroupByAccumulator;

public abstract class DroolsAbstractBiCollectingGroupByAccumulator<ResultContainer1, ResultContainer2, InTuple, KeyTuple, OutTuple>
implements GroupByAccumulator<InTuple, OutTuple> {
    private final Map<ResultContainer1, Long> containersInUseMap1 = new IdentityHashMap<ResultContainer1, Long>(0);
    private final Map<ResultContainer2, Long> containersInUseMap2 = new IdentityHashMap<ResultContainer2, Long>(0);
    private final Map<KeyTuple, ResultContainer1> containersMap1 = new LinkedHashMap<KeyTuple, ResultContainer1>(0);
    private final Map<KeyTuple, ResultContainer2> containersMap2 = new LinkedHashMap<KeyTuple, ResultContainer2>(0);
    private final transient Set<OutTuple> resultSet = new LinkedHashSet<OutTuple>(0);

    private <ResultContainer> Runnable accumulate(InTuple input, Supplier<ResultContainer> containerSupplier, BiFunction<InTuple, ResultContainer, Runnable> inputProcessor, Map<KeyTuple, ResultContainer> containersMap, Map<ResultContainer, Long> containersInUseMap) {
        Object key = this.toKey(input);
        Object container = containersMap.computeIfAbsent(key, __ -> containerSupplier.get());
        Runnable undo = inputProcessor.apply(input, container);
        containersInUseMap.compute(container, (__, count) -> DroolsAbstractBiCollectingGroupByAccumulator.increment(count));
        return () -> {
            undo.run();
            Long currentCount = containersInUseMap.compute(container, (__, count) -> DroolsAbstractBiCollectingGroupByAccumulator.decrement(count));
            if (currentCount == null) {
                containersMap.remove(key);
            }
        };
    }

    @Override
    public Runnable accumulate(InTuple input) {
        Runnable firstUndo = this.accumulate(input, this::newFirstContainer, this::processFirst, this.containersMap1, this.containersInUseMap1);
        Runnable secondUndo = this.accumulate(input, this::newSecondContainer, this::processSecond, this.containersMap2, this.containersInUseMap2);
        return () -> {
            firstUndo.run();
            secondUndo.run();
        };
    }

    private static Long increment(Long count) {
        return count == null ? 1L : count + 1L;
    }

    private static Long decrement(Long count) {
        return count == 1L ? null : Long.valueOf(count - 1L);
    }

    @Override
    public Set<OutTuple> finish() {
        this.resultSet.clear();
        for (Map.Entry<KeyTuple, ResultContainer1> entry : this.containersMap1.entrySet()) {
            KeyTuple key = entry.getKey();
            ResultContainer1 firstContainer = entry.getValue();
            ResultContainer2 secondContainer = this.containersMap2.get(key);
            this.resultSet.add(this.toResult(key, firstContainer, secondContainer));
        }
        return this.resultSet;
    }

    protected abstract KeyTuple toKey(InTuple var1);

    protected abstract ResultContainer1 newFirstContainer();

    protected abstract ResultContainer2 newSecondContainer();

    protected abstract Runnable processFirst(InTuple var1, ResultContainer1 var2);

    protected abstract Runnable processSecond(InTuple var1, ResultContainer2 var2);

    protected abstract OutTuple toResult(KeyTuple var1, ResultContainer1 var2, ResultContainer2 var3);
}

