/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.cdi.impl;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeNonCDIImplExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(ExcludeNonCDIImplExtension.class);
    private Set<String> excluded = new HashSet<String>();

    public ExcludeNonCDIImplExtension() {
        this.excluded.add("org.jbpm.executor.impl");
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        Package pkg = javaClass.getPackage();
        if (pkg != null && this.excluded.contains(pkg.getName())) {
            logger.debug("jBPM Exeutor CDI integration :: excluding package {}", (Object)pkg.getName());
            pat.veto();
        } else if (javaClass != null && this.excluded.contains(javaClass.getName())) {
            logger.debug("jBPM Exeutor CDI integration :: excluding class {}" + javaClass.getName());
            pat.veto();
        }
    }
}

